/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.hex.swing;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.fife.ui.hex.event.HexEditorEvent;
import org.fife.ui.hex.event.HexEditorListener;
import org.fife.ui.hex.swing.HexEditorRowHeader;
import org.fife.ui.hex.swing.HexEditorTransferHandler;
import org.fife.ui.hex.swing.HexTable;
import org.fife.ui.hex.swing.HexTableModel;

public class HexEditor
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ALTERNATE_COLUMN_BG = "alternateColBG";
    public static final String PROPERTY_ALTERNATE_ROW_BG = "alternateRowBG";
    public static final String PROPERTY_ASCII_DUMP_HIGHLIGHT_COLOR = "asciiDumpHighlightColor";
    public static final String PROPERTY_HIGHLIGHT_ASCII_DUMP = "highlightAsciiDump";
    public static final String PROPERTY_SHOW_GRID = "showGrid";
    private HexTable table;
    private boolean alternateRowBG;
    private boolean alternateColumnBG;
    private boolean highlightSelectionInAsciiDump;
    private Color highlightSelectionInAsciiDumpColor;
    private boolean editable = true;
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new HexEditorTransferHandler();
    static final int DUMP_COLUMN_WIDTH = 200;
    private static final String MSG = "org.fife.ui.hex.HexEditor";

    public HexEditor(boolean bl) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MSG);
        HexTableModel hexTableModel = new HexTableModel(this, resourceBundle);
        this.table = new HexTable(this, hexTableModel);
        this.setEditable(bl);
        this.setViewportView(this.table);
        this.setShowRowHeader(true);
        this.setAlternateRowBG(false);
        this.setAlternateColumnBG(false);
        this.setHighlightSelectionInAsciiDump(true);
        this.setHighlightSelectionInAsciiDumpColor(new Color(255, 255, 192));
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
    }

    public HexEditor() {
        this(true);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void addHexEditorListener(HexEditorListener hexEditorListener) {
        this.listenerList.add(HexEditorListener.class, hexEditorListener);
    }

    public int cellToOffset(int n, int n2) {
        return this.table.cellToOffset(n, n2);
    }

    public void copy() {
        this.invokeAction(TransferHandler.getCopyAction());
    }

    public void cut() {
        this.invokeAction(TransferHandler.getCutAction());
    }

    public void delete() {
        if (this.table.leadSelectionIndex == -1 || this.table.anchorSelectionIndex == -1) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.table);
            return;
        }
        int n = this.table.getSmallestSelectionIndex();
        int n2 = this.table.getLargestSelectionIndex();
        int n3 = n2 - n + 1;
        this.removeBytes(n, n3);
    }

    protected void fireHexEditorEvent(int n, int n2, int n3) {
        HexEditorEvent hexEditorEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HexEditorListener.class) continue;
            if (hexEditorEvent == null) {
                hexEditorEvent = new HexEditorEvent(this, n, n2, n3);
            }
            ((HexEditorListener)objectArray[i + 1]).hexBytesChanged(hexEditorEvent);
        }
    }

    public boolean getAlternateColumnBG() {
        return this.alternateColumnBG;
    }

    public boolean getAlternateRowBG() {
        return this.alternateRowBG;
    }

    public byte getByte(int n) {
        return this.table.getByte(n);
    }

    public int getByteCount() {
        return this.table.getByteCount();
    }

    public boolean getHighlightSelectionInAsciiDump() {
        return this.highlightSelectionInAsciiDump;
    }

    public Color getHighlightSelectionInAsciiDumpColor() {
        return this.highlightSelectionInAsciiDumpColor;
    }

    public int getLargestSelectionIndex() {
        return this.table.getLargestSelectionIndex();
    }

    public int getSmallestSelectionIndex() {
        return this.table.getSmallestSelectionIndex();
    }

    HexTable getTable() {
        return this.table;
    }

    private void invokeAction(Action action) {
        action.actionPerformed(new ActionEvent(this, 1001, (String)action.getValue("Name"), EventQueue.getMostRecentEventTime(), 0));
    }

    public Point offsetToCell(int n) {
        return this.table.offsetToCell(n);
    }

    public void open(String string) throws IOException {
        this.table.open(string);
    }

    public void open(InputStream inputStream) throws IOException {
        this.table.open(inputStream);
    }

    public void paste() {
        this.invokeAction(TransferHandler.getPasteAction());
    }

    public boolean redo() {
        return this.table.redo();
    }

    public void removeBytes(int n, int n2) {
        this.table.removeBytes(n, n2);
        this.table.changeSelectionByOffset(n, false);
    }

    public void removeHexEditorListener(HexEditorListener hexEditorListener) {
        this.listenerList.remove(HexEditorListener.class, hexEditorListener);
    }

    public void replaceBytes(int n, int n2, byte[] byArray) {
        if (n2 == 1) {
            n2 = 0;
        }
        this.table.replaceBytes(n, n2, byArray);
        this.table.changeSelectionByOffset(this.table.anchorSelectionIndex, false);
        int n3 = byArray == null ? 0 : byArray.length;
        this.table.setSelectionByOffsets(n, n + n3 - 1);
    }

    public void replaceSelection(byte[] byArray) {
        int n = this.table.getSmallestSelectionIndex();
        int n2 = this.table.getLargestSelectionIndex() - n + 1;
        this.replaceBytes(n, n2, byArray);
    }

    public void setAlternateColumnBG(boolean bl) {
        if (bl != this.alternateColumnBG) {
            this.alternateColumnBG = bl;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_ALTERNATE_COLUMN_BG, !bl, bl);
        }
    }

    public void setAlternateRowBG(boolean bl) {
        if (bl != this.alternateRowBG) {
            this.alternateRowBG = bl;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_ALTERNATE_ROW_BG, !bl, bl);
        }
    }

    public void setHighlightSelectionInAsciiDump(boolean bl) {
        if (bl != this.highlightSelectionInAsciiDump) {
            this.highlightSelectionInAsciiDump = bl;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_HIGHLIGHT_ASCII_DUMP, !bl, bl);
        }
    }

    public void setHighlightSelectionInAsciiDumpColor(Color color) {
        if (color != null && !color.equals(this.highlightSelectionInAsciiDumpColor)) {
            Color color2 = this.highlightSelectionInAsciiDumpColor;
            this.highlightSelectionInAsciiDumpColor = color;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_ASCII_DUMP_HIGHLIGHT_COLOR, color2, color);
        }
    }

    public void setSelectedRange(int n, int n2) {
        this.table.setSelectionByOffsets(n, n2);
    }

    public void setShowColumnHeader(boolean bl) {
        this.table.setShowColumnHeader(bl);
    }

    public void setShowGrid(boolean bl) {
        if (bl != this.table.getShowHorizontalLines()) {
            this.table.setShowGrid(bl);
            this.firePropertyChange(PROPERTY_SHOW_GRID, !bl, bl);
        }
    }

    public void setShowRowHeader(boolean bl) {
        this.setRowHeaderView(bl ? new HexEditorRowHeader(this.table) : null);
    }

    public boolean undo() {
        return this.table.undo();
    }
}

