/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.TypeObject;
import java.awt.Color;
import java.util.Hashtable;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class RendererPreferences {
    private Hashtable<Object, TypeObject> typesTable = new Hashtable();
    private Color defaultColor = Color.black;
    private Color defaultSelectedBackground;
    private Color defaultSelectedForeground;
    private AbstractTreeModel treeModel;
    private Properties properties;

    public RendererPreferences(AbstractTreeModel treeModel) {
        this.treeModel = treeModel;
        this.properties = treeModel.getProperties();
        try {
            this.defaultSelectedBackground = this.properties.getColor("default.selected.background");
        }
        catch (MissingResourceException e) {
            this.defaultSelectedBackground = new Color(204, 204, 204);
        }
        try {
            this.defaultSelectedForeground = this.properties.getColor("default.selected.foreground");
        }
        catch (MissingResourceException e) {
            this.defaultSelectedForeground = null;
        }
        this.readDefaultTypes(treeModel.getDefaultTypes());
    }

    public AbstractTreeModel getTreeModel() {
        return this.treeModel;
    }

    public Color getDefaultSelectedBackground() {
        return this.defaultSelectedBackground;
    }

    public Color getDefaultSelectedForeground() {
        return this.defaultSelectedForeground;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getType(Object value) {
        return this.treeModel.getType(value);
    }

    public String toString(Object value) {
        return this.treeModel.toString(value);
    }

    public String getTooltip(Object value) {
        return this.treeModel.getTooltip(value);
    }

    public Color getColor(int type, boolean leaf, boolean expanded) {
        TypeObject obj = this.getTypeObject(type);
        Color result = expanded ? obj.openColor : (leaf ? obj.leafColor : obj.closedColor);
        return result;
    }

    public Icon getEditingIcon(Object value, boolean leaf, boolean expanded) {
        int type = this.getType(value);
        TypeObject obj = this.getTypeObject(type);
        return obj.editIcon == null ? this.getIcons(type, leaf, expanded, true)[0] : obj.editIcon;
    }

    public Icon[] getIcons(int type, boolean leaf, boolean expanded, boolean selected) {
        TypeObject obj = this.getTypeObject(type);
        if (selected) {
            return new Icon[]{obj.selectedOpenIcon, obj.disabledSelectedIcon};
        }
        if (expanded) {
            return new Icon[]{obj.openIcon, obj.disabledOpenIcon};
        }
        if (leaf) {
            return new Icon[]{obj.leafIcon, obj.disabledLeafIcon};
        }
        return new Icon[]{obj.closedIcon, obj.disabledClosedIcon};
    }

    public Color[] getSelectedColors(int type) {
        Color[] result = new Color[2];
        TypeObject obj = this.getTypeObject(type);
        result[0] = obj.selectedBackground;
        result[1] = obj.selectedForeground;
        return result;
    }

    public int getFontStyle(int type) {
        return this.getTypeObject((int)type).fontStyle;
    }

    private void readDefaultTypes(Object[][] defaultTypes) {
        int length = defaultTypes.length;
        for (int i = 0; i < length; ++i) {
            this.typesTable.put(defaultTypes[i][0], this.createTypeObject(defaultTypes[i][1], -1));
        }
    }

    private TypeObject createTypeObject(Object type, int key) {
        TypeObject typeObject = new TypeObject();
        this.readColors(typeObject, type, key);
        this.readIcons(typeObject, type, key);
        this.readFontStyle(typeObject, type, key);
        return typeObject;
    }

    private void readIcons(TypeObject typeObject, Object type, int key) {
        if (type instanceof Icon) {
            Icon typeIcon;
            typeObject.leafIcon = typeIcon = (Icon)type;
            typeObject.disabledLeafIcon = typeIcon;
            typeObject.closedIcon = typeIcon;
            typeObject.disabledClosedIcon = typeIcon;
            typeObject.openIcon = typeIcon;
            typeObject.disabledOpenIcon = typeIcon;
            typeObject.editIcon = typeIcon;
            typeObject.selectedOpenIcon = typeIcon;
            typeObject.disabledSelectedIcon = typeIcon;
        } else if (type == null) {
            typeObject.leafIcon = this.treeModel.getTypeIcon(key, true, false, false);
            typeObject.closedIcon = this.treeModel.getTypeIcon(key, false, false, false);
            typeObject.openIcon = this.treeModel.getTypeIcon(key, false, true, false);
            typeObject.selectedOpenIcon = this.treeModel.getTypeIcon(key, false, false, true);
        } else {
            String typeString = type.toString();
            Icon defaultIcon = this.treeModel.getTypeIcon(key, true, false, false);
            if (defaultIcon == null) {
                defaultIcon = UIManager.getIcon("Tree.leafIcon");
            }
            typeObject.leafIcon = this.getIcon(typeString, "leaf", defaultIcon);
            typeObject.disabledLeafIcon = this.getDisabledIcon(typeString, "leaf", typeObject.leafIcon);
            defaultIcon = this.treeModel.getTypeIcon(key, false, false, false);
            if (defaultIcon == null) {
                defaultIcon = UIManager.getIcon("Tree.closedIcon");
            }
            typeObject.closedIcon = this.getIcon(typeString, "closed", defaultIcon);
            typeObject.disabledClosedIcon = this.getDisabledIcon(typeString, "closed", typeObject.closedIcon);
            defaultIcon = this.treeModel.getTypeIcon(key, false, true, false);
            if (defaultIcon == null) {
                defaultIcon = UIManager.getIcon("Tree.openIcon");
            }
            typeObject.openIcon = this.getIcon(typeString, "open", defaultIcon);
            typeObject.disabledOpenIcon = this.getDisabledIcon(typeString, "open", typeObject.openIcon);
            typeObject.editIcon = this.getIcon(typeString, "edit", null);
            typeObject.selectedOpenIcon = this.getIcon(typeString, "selected", typeObject.openIcon);
            typeObject.disabledSelectedIcon = this.getDisabledIcon(typeString, "selected", typeObject.selectedOpenIcon);
        }
    }

    private void readColors(TypeObject typeObject, Object type, int key) {
        if (type instanceof Color) {
            Color typeColor;
            typeObject.leafColor = typeColor = (Color)type;
            typeObject.closedColor = typeColor;
            typeObject.openColor = typeColor;
        } else if (type == null) {
            typeObject.leafColor = this.treeModel.getTypeColor(key, true, false, false);
            typeObject.closedColor = this.treeModel.getTypeColor(key, false, false, false);
            typeObject.openColor = this.treeModel.getTypeColor(key, false, false, true);
        } else {
            String typeString = type.toString();
            typeObject.leafColor = this.getColor(typeString, "leaf");
            if (typeObject.leafColor == null) {
                typeObject.leafColor = this.treeModel.getTypeColor(key, true, false, false);
            }
            typeObject.closedColor = this.getColor(typeString, "closed");
            if (typeObject.closedColor == null) {
                typeObject.closedColor = this.treeModel.getTypeColor(key, false, false, false);
            }
            typeObject.openColor = this.getColor(typeString, "open");
            if (typeObject.openColor == null) {
                typeObject.openColor = this.treeModel.getTypeColor(key, false, true, false);
            }
            this.readSelectedColors(typeString, typeObject, key);
        }
    }

    private void readSelectedColors(String typeString, TypeObject typeObject, int type) {
        if (this.properties != null) {
            String key;
            block9: {
                try {
                    key = typeString + ".selected.foreground";
                    try {
                        typeObject.selectedForeground = this.properties.getColor(key);
                    }
                    catch (MissingResourceException e) {
                        key = typeString + "_selected_foreground";
                        typeObject.selectedForeground = this.properties.getColor(key);
                    }
                }
                catch (MissingResourceException e) {
                    typeObject.selectedForeground = this.treeModel.getTypeColor(type, false, false, true);
                    if (typeObject.selectedForeground != null) break block9;
                    typeObject.selectedForeground = this.defaultSelectedForeground;
                }
            }
            try {
                key = typeString + ".selected.background";
                try {
                    typeObject.selectedBackground = this.properties.getColor(key);
                }
                catch (MissingResourceException e) {
                    key = typeString + "_selected_background";
                    typeObject.selectedBackground = this.properties.getColor(key);
                }
            }
            catch (MissingResourceException e) {
                typeObject.selectedBackground = this.defaultSelectedBackground;
            }
        }
    }

    private Color getColor(String typeString, String state) {
        Color result;
        try {
            result = this.readColor(typeString, state, this.defaultColor);
        }
        catch (MissingResourceException mrEx) {
            String key = typeString + ".color";
            try {
                result = this.properties.getColor(key);
            }
            catch (Exception e) {
                key = typeString + "_color";
                result = this.properties.getColor(key, this.defaultColor);
            }
        }
        return result;
    }

    private Color readColor(String typeString, String state, Color defaultColor) {
        Color result;
        if (this.properties == null) {
            result = defaultColor;
        } else {
            String key = typeString + "." + state + ".color";
            try {
                result = this.properties.getColor(key);
            }
            catch (MissingResourceException e) {
                key = typeString + "_" + state + "_color";
                result = this.properties.getColor(key);
            }
        }
        return result;
    }

    private Icon getDisabledIcon(String typeString, String state, Icon defaultIcon) {
        try {
            if (this.properties != null) {
                String iconString = this.properties.getString(typeString + "_" + state + "_disabled_icon");
                ImageIcon icon = ImageLoader.loadIcon((String)iconString, (boolean)false, (ClassLoader)this.getClass().getClassLoader());
                return icon == null ? defaultIcon : icon;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return defaultIcon;
    }

    private Icon getIcon(String typeString, String state, Icon defaultIcon) {
        Icon icon = null;
        String iconString = this.getProperty(typeString, state, "icon");
        if (iconString.length() > 0) {
            try {
                ClassLoader classLoader = this.properties == null ? this.getClass().getClassLoader() : this.properties.getUsedClassLoader();
                icon = ImageLoader.loadIcon((String)iconString, (boolean)false, (ClassLoader)classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (icon == null) {
            icon = defaultIcon;
        }
        return icon;
    }

    private void readFontStyle(TypeObject typeObject, Object type, int key) {
        if (type instanceof Integer) {
            typeObject.fontStyle = (Integer)type;
        } else if (type == null) {
            typeObject.fontStyle = 0;
        } else {
            String styleProperty = this.getProperty(type.toString(), "font", "style");
            try {
                int fontStyle = 0;
                styleProperty = styleProperty.toLowerCase();
                if (styleProperty.indexOf("italic") != -1) {
                    fontStyle |= 2;
                }
                if (styleProperty.indexOf("bold") != -1) {
                    fontStyle |= 1;
                }
                if (fontStyle == 0) {
                    fontStyle = 0;
                }
                typeObject.fontStyle = fontStyle;
            }
            catch (Exception e) {
                typeObject.fontStyle = 0;
            }
        }
    }

    private String getProperty(String typeString, String state, String value) {
        String result;
        try {
            if (this.properties == null) {
                result = typeString;
            } else {
                try {
                    result = this.properties.getString(typeString + "." + state + "." + value);
                }
                catch (MissingResourceException mrEx) {
                    result = this.properties.getString(typeString + "_" + state + "_" + value);
                }
            }
        }
        catch (MissingResourceException mrEx1) {
            try {
                result = this.properties.getString(typeString + "." + value);
            }
            catch (MissingResourceException mrEx2) {
                try {
                    result = this.properties.getString(typeString + "_" + value);
                }
                catch (MissingResourceException mrEx3) {
                    result = typeString;
                }
            }
        }
        return result;
    }

    private TypeObject getTypeObject(int type) {
        TypeObject obj = this.typesTable.get(type);
        if (obj == null) {
            obj = this.createNewType(type, this.treeModel.getTypeString(type));
        }
        return obj;
    }

    private TypeObject createNewType(int key, String typeString) {
        TypeObject obj = this.createTypeObject(typeString, key);
        this.typesTable.put(key, obj);
        return obj;
    }
}

