/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.io.FileUtilities;
import ch.e2e.swing.MouseOverButton;
import ch.e2e.swing.event.DirectoryActionEvent;
import ch.e2e.swing.event.DirectoryActionEventMulticaster;
import ch.e2e.swing.event.DirectoryActionListener;
import ch.e2e.swing.filechooser.DirectoryButtonPanel;
import ch.e2e.swing.filechooser.FileChooserConstants;
import ch.e2e.swing.model.Directory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;

public class SmallDirectoryButtonPanel
extends DirectoryButtonPanel {
    public static final int UP = 1;
    public static final int HOME = 2;
    public static final int NEW = 4;
    public static final int DELETE = 8;
    public static final int SHOW_FOLDERS = 16;
    public static final int SHOW_FILES = 32;
    public static final int ALL = 63;
    private MouseOverButton upButton;
    private MouseOverButton homeButton;
    private MouseOverButton deleteButton;
    private MouseOverButton newButton;
    private MouseOverButton showFoldersButton;
    private MouseOverButton showFilesButton;
    private DirectoryActionListener directoryActionListener;

    public SmallDirectoryButtonPanel(int buttons) {
        super(0);
        this.createGui(buttons);
    }

    public void addDirectoryActionListener(DirectoryActionListener directoryActionListener) {
        this.directoryActionListener = DirectoryActionEventMulticaster.addListener(this.directoryActionListener, directoryActionListener);
    }

    public void removeDirectoryActionListener(DirectoryActionListener directoryActionListener) {
        this.directoryActionListener = DirectoryActionEventMulticaster.removeListener(this.directoryActionListener, directoryActionListener);
    }

    @Override
    protected void selectDirectory(Directory selectedDirectory) {
        if (this.upButton != null) {
            if (selectedDirectory.getParent() == null) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(selectedDirectory.getDir() != null && FileUtilities.isEmpty((File)selectedDirectory.getDir()) && selectedDirectory.getDir().canWrite());
        }
        if (this.homeButton != null && selectedDirectory.getDir() != null) {
            this.homeButton.setPressed(selectedDirectory.getDir().equals(FileChooserConstants.USER_HOME));
        }
        if (this.newButton != null) {
            this.newButton.setEnabled(selectedDirectory.getDir() != null);
        }
    }

    private void fireCreateNewDirectory(Directory parentFile) {
        if (this.directoryActionListener != null) {
            this.directoryActionListener.createNewDirectory(new DirectoryActionEvent(this, parentFile, 0));
        }
    }

    private void fireDeleteDirectory(Directory selectedDirectory) {
        if (this.directoryActionListener != null) {
            this.directoryActionListener.deleteDirectory(new DirectoryActionEvent(this, selectedDirectory, 1));
        }
    }

    private void createGui(int buttons) {
        if ((buttons & 1) == 1) {
            this.upButton = this.addButton((Icon)folderUpIcon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SmallDirectoryButtonPanel.this.selectedDirectory != null) {
                        SmallDirectoryButtonPanel.this.fireDirectorySelected(SmallDirectoryButtonPanel.this.selectedDirectory.getParent());
                    }
                }
            });
        }
        if ((buttons & 2) == 2) {
            this.homeButton = this.addButton((Icon)folderHomeIcon, FileChooserConstants.USER_HOME);
        }
        if ((buttons & 4) == 4) {
            this.newButton = this.addButton((Icon)folderNewIcon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SmallDirectoryButtonPanel.this.fireCreateNewDirectory(SmallDirectoryButtonPanel.this.selectedDirectory);
                }
            });
        }
        if ((buttons & 8) == 8) {
            this.deleteButton = this.addButton((Icon)folderDeleteIcon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SmallDirectoryButtonPanel.this.fireDeleteDirectory(SmallDirectoryButtonPanel.this.selectedDirectory);
                }
            });
        }
        if ((buttons & 0x10) == 16) {
            this.showFoldersButton = this.addButton((Icon)showFoldersIcon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                }
            });
        }
        if ((buttons & 0x20) == 32) {
            this.showFilesButton = this.addButton((Icon)showFilesIcon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                }
            });
        }
    }
}

