/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.MessageGroup;
import ch.e2e.swing.MessageType;
import ch.e2e.util.StringTools;
import java.awt.Color;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class Message {
    public static final String _SHORT = ".short";
    public static final String _DETAIL = ".detail";
    public static final String _HELP = ".hint";
    private MessageGroup group;
    private String code;
    private MessageType messageType;
    private Map<String, String> parameter;

    public Message(String code) {
        this(code, null, new HashMap<String, String>(), null);
    }

    public Message(String code, Map<String, String> parameter, MessageType type) {
        this(code, null, parameter, type);
    }

    public Message(String code, MessageGroup group) {
        this(code, group, new HashMap<String, String>(), null);
    }

    public Message(String code, MessageGroup group, Map<String, String> parameter, MessageType type) {
        this.code = code;
        this.group = group;
        this.parameter = parameter;
        this.messageType = type;
    }

    public void setGroup(MessageGroup group) {
        this.group = group;
    }

    public String getMessage() {
        return this.getParameterizedMessage(this.code);
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String toString() {
        return this.getMessage();
    }

    protected String getParameterizedMessage(String message) {
        return this.parameter == null ? message : StringTools.replaceProperties((String)message, this.parameter);
    }

    protected String getCode() {
        return this.code;
    }

    public MessageGroup getGroup() {
        return this.group;
    }

    public Style[] getStyles(StyleContext context, Color foreground, Color background) {
        Style def;
        Style[] result = new Style[2];
        Style style = result[0] = this.messageType == null ? null : context.getStyle(this.messageType.type + ".icon");
        if (result[0] == null) {
            def = context.getStyle("default");
            StyleConstants.setFontFamily(def, "SansSerif");
            StyleConstants.setFontSize(def, 8);
            result[0] = context.addStyle(this.messageType.type, def);
            StyleConstants.setFontFamily(result[0], "SansSerif");
            StyleConstants.setFontSize(result[0], 8);
            StyleConstants.setLineSpacing(result[0], -0.8f);
            StyleConstants.setAlignment(result[0], 0);
            if (this.messageType.icon == null) {
                StyleConstants.setIcon(result[0], new ImageIcon(Toolkit.getDefaultToolkit().createImage(new byte[]{0})));
            } else {
                StyleConstants.setIcon(result[0], this.messageType.icon);
            }
            if (this.messageType.foreground == null) {
                StyleConstants.setForeground(result[0], foreground);
            } else {
                StyleConstants.setForeground(result[0], this.messageType.foreground);
            }
            if (this.messageType.background == null) {
                StyleConstants.setBackground(result[0], background);
            } else {
                StyleConstants.setBackground(result[0], this.messageType.background);
            }
        }
        Style style2 = result[1] = this.messageType == null ? null : context.getStyle(this.messageType.type + ".text");
        if (result[1] == null) {
            def = context.getStyle("default");
            result[1] = context.addStyle(this.messageType.type, def);
            StyleConstants.setFontFamily(result[1], "SansSerif");
            StyleConstants.setFontSize(result[1], 14);
            StyleConstants.setAlignment(result[1], 0);
            if (this.messageType.foreground == null) {
                StyleConstants.setForeground(result[0], foreground);
            } else {
                StyleConstants.setForeground(result[0], this.messageType.foreground);
            }
            if (this.messageType.background == null) {
                StyleConstants.setBackground(result[0], background);
            } else {
                StyleConstants.setBackground(result[0], this.messageType.background);
            }
        }
        return result;
    }
}

