/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class InputCheckBox
extends JCheckBox
implements InputField,
ItemListener {
    private InputFieldListener listener;

    public InputCheckBox(String label) {
        this(label, false);
    }

    public InputCheckBox(String label, boolean state) {
        super(label, state);
        this.addItemListener(this);
    }

    @Override
    public Object getContent() {
        return this.isSelected();
    }

    @Override
    public void setContent(Object content) {
        Boolean bool = (Boolean)content;
        if (bool != null && bool.booleanValue()) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            this.listener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireInputField();
    }

    @Override
    public void setEditable(boolean editable) {
        this.setEnabled(editable);
    }
}

