/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

public class CharacterSetOrientation {
    private String codePage;
    private String encoding;
    private int ascender;
    private int descender;
    private int capHeight;
    private int[] chars = new int[256];
    private int xHeight;
    private int firstChar;
    private int lastChar;
    private int orientation = 0;

    public CharacterSetOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(this.chars, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public int getXHeight() {
        return this.xHeight;
    }

    public int width(int character) {
        return this.chars[character];
    }

    public void setAscender(int ascender) {
        this.ascender = ascender;
    }

    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
    }

    public void setDescender(int descender) {
        this.descender = descender;
    }

    public void setFirstChar(int firstChar) {
        this.firstChar = firstChar;
    }

    public void setLastChar(int lastChar) {
        this.lastChar = lastChar;
    }

    public void setWidth(int character, int width) {
        if (character >= this.chars.length) {
            int[] arr = new int[character - this.firstChar + 1];
            System.arraycopy(this.chars, 0, arr, 0, this.chars.length);
            this.chars = arr;
        }
        this.chars[character] = width;
    }

    public void setXHeight(int xHeight) {
        this.xHeight = xHeight;
    }
}

