/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Message
extends UmlObject {
    private static final int SHORT_MESSAGE_LENGTH = 30;
    private String category;
    private String domain;
    private String code;
    private String description;

    public Message(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.writeIOEntry(traceContainer, element);
    }

    public Message(Element element, File documentFolder) {
        super(element.getTextContent());
        this.readIOEntry(documentFolder);
    }

    public String getCategory() {
        return this.category;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    private void writeIOEntry(TraceContainer traceContainer, Element element) {
        if (this.domain != null && this.category != null && this.code != null) {
            this.name = traceContainer.addIOEntry(element, "MESSAGE");
        }
    }

    private void readIOEntry(File documentFolder) {
        try {
            File ioFile = new File(documentFolder, ".io");
            Document document = ZipUtilities.getZippedDocumentFromFile((File)ioFile, (String)this.getName());
            if (document != null) {
                NodeList nodes = document.getDocumentElement().getFirstChild().getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element)) continue;
                    this.addChild((Element)node, documentFolder);
                }
            }
        }
        catch (Exception e) {
            this.description = "";
        }
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        if (child.getNodeName().equals("category")) {
            this.category = this.readValue(child);
        } else if (child.getNodeName().equals("code")) {
            this.code = this.readValue(child);
        } else if (child.getNodeName().equals("description")) {
            this.description = this.readValue(child);
        } else if (child.getNodeName().equals("domain")) {
            this.domain = this.readValue(child);
        } else {
            super.addChild(child, documentFolder);
        }
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        if (child.getNodeName().equals("category")) {
            this.category = this.readValue(child);
        } else if (child.getNodeName().equals("code")) {
            this.code = this.readValue(child);
        } else if (child.getNodeName().equals("description")) {
            this.description = this.readValue(child);
        } else if (child.getNodeName().equals("domain")) {
            this.domain = this.readValue(child);
        } else {
            super.addChild(child, traceContainer);
        }
    }

    private String readValue(Element child) {
        return child.hasChildNodes() ? child.getFirstChild().getNodeValue() : "";
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int internalGetType() {
        return 10041;
    }

    @Override
    public String toString() {
        String s = this.getDescription();
        return s.length() <= 30 ? s : s.substring(0, 30) + "...";
    }
}

