/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.InputExpansionNode;
import ch.e2e.builder.trace.testcase.uml.IteratedInput;
import ch.e2e.builder.trace.testcase.uml.IteratorOutput;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.OutputExpansionNode;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class IteratorFlow
extends Flow {
    private List<IOUmlObject> iterations;
    private IteratedInput iteratedInput;
    private Map<String, IteratorOutput> iteratorOutputs;
    private List<Data> nonIteratedInputs;
    private List<Data> nonIteratedOutputs;

    public IteratorFlow(Element flowElement, File documentFolder) {
        super(flowElement, documentFolder);
        if (this.iteratorOutputs == null) {
            this.iteratorOutputs = Collections.emptyMap();
        }
        if (this.iterations == null) {
            this.iterations = Collections.emptyList();
        }
        this.setupNonIteratedIO();
    }

    public IteratorFlow(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        if (this.iteratorOutputs == null) {
            this.iteratorOutputs = Collections.emptyMap();
        }
        if (this.iterations == null) {
            this.iterations = Collections.emptyList();
        }
        this.setupNonIteratedIO();
    }

    @Override
    public void addChild(UmlObject child) {
        if (child instanceof IOUmlObject) {
            if (this.iterations == null) {
                this.iterations = new ArrayList<IOUmlObject>();
            }
            this.iterations.add((IOUmlObject)child);
        }
        child.setIndex(this.getChildCount());
        super.addChild(child);
    }

    public IteratedInput getIteratedInput() {
        return this.iteratedInput;
    }

    public IteratorOutput getIteratorOutput(String name) {
        return this.iteratorOutputs.get(name);
    }

    public List<Data> getNonIteratedInputs() {
        return this.nonIteratedInputs;
    }

    public List<Data> getNonIteratedOutputs() {
        return this.nonIteratedOutputs;
    }

    public List<IOUmlObject> getIterations() {
        return this.iterations;
    }

    @Override
    public int internalGetType() {
        return 10015;
    }

    @Override
    protected void ioObjectAddChild(Element child, TraceContainer traceContainer) {
        UmlObject umlObject = UmlObjectFactory.createUmlObject(child, traceContainer, true);
        if (umlObject instanceof Message) {
            this.error = true;
        }
        this.addChild(umlObject);
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        String nodeName = child.getNodeName();
        if (nodeName.equals("inputExpansionNode")) {
            this.setInput(new InputExpansionNode(this, child, traceContainer));
        } else if (nodeName.equals("outputExpansionNode")) {
            this.setOutput(new OutputExpansionNode(this, child, traceContainer));
        } else if (nodeName.equals("iteratedInput")) {
            this.setIteratedInput(new IteratedInput(this, child));
        } else if (nodeName.equals("iteratorOutput")) {
            this.addIteratorOutput(new IteratorOutput(this, child));
        } else {
            super.addChild(child, traceContainer);
        }
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        String nodeName = child.getNodeName();
        if (nodeName.equals("inputExpansionNode")) {
            this.setInput(new InputExpansionNode(this, child));
        } else if (nodeName.equals("outputExpansionNode")) {
            this.setOutput(new OutputExpansionNode(this, child));
        } else if (nodeName.equals("iteratedInput")) {
            this.setIteratedInput(new IteratedInput(this, child));
        } else if (nodeName.equals("iteratorOutput")) {
            this.addIteratorOutput(new IteratorOutput(this, child));
        } else {
            super.addChild(child, documentFolder);
        }
    }

    private void setIteratedInput(IteratedInput iteratedInput) {
        this.iteratedInput = iteratedInput;
    }

    private void addIteratorOutput(IteratorOutput iteratorOutput) {
        if (this.iteratorOutputs == null) {
            this.iteratorOutputs = new HashMap<String, IteratorOutput>();
        }
        this.iteratorOutputs.put(iteratorOutput.getSource(), iteratorOutput);
    }

    private void setupNonIteratedIO() {
        if (this.iteratedInput == null || this.iterations.isEmpty()) {
            this.nonIteratedInputs = Collections.emptyList();
            this.nonIteratedOutputs = Collections.emptyList();
        } else {
            this.nonIteratedInputs = new ArrayList<Data>();
            String name = this.iteratedInput.getTarget();
            DataContainer dataContainer = this.iterations.get(0).getInput();
            int childCount = dataContainer.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                Data child = (Data)dataContainer.getChild(i);
                if (child.getName().equals(name)) continue;
                this.nonIteratedInputs.add(child);
            }
            this.nonIteratedOutputs = new ArrayList<Data>();
            ArrayList<String> names = new ArrayList<String>(this.iteratorOutputs.size());
            for (IteratorOutput output : this.iteratorOutputs.values()) {
                names.add(output.getSource());
            }
            dataContainer = this.iterations.get(this.iterations.size() - 1).getOutput();
            childCount = dataContainer.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                Data child = (Data)dataContainer.getChild(i);
                if (names.contains(child.getName())) continue;
                this.nonIteratedOutputs.add(child);
            }
        }
    }
}

