/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.InspectionEvent;
import ch.e2e.builder.trace.testcase.uml.InspectionListener;
import ch.e2e.builder.trace.testcase.uml.InspectionObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.io.File;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;

public class Activity
extends UmlObject
implements InspectionObject {
    private boolean inspected = false;
    private int type;
    private long startTime;
    private long stopTime;
    private EventListenerList listeners = new EventListenerList();

    public Activity(Element element, File documentFolder) {
        super(element, documentFolder);
        this.initialize();
    }

    public Activity(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        element.setAttribute("runtime", String.valueOf(this.stopTime - this.startTime + "ms"));
        this.initialize();
    }

    @Override
    public int internalGetType() {
        return this.type;
    }

    private void initialize() {
        if (this.name.equals("-")) {
            this.type = 10012;
            this.name = "< >";
        } else {
            this.type = 10001;
        }
    }

    @Override
    public String getId() {
        return this.getOriginalName();
    }

    @Override
    public boolean isInspected() {
        return this.inspected;
    }

    @Override
    public void setInspected(boolean inspected) {
        if (this.inspected ^ inspected) {
            this.inspected = inspected;
            this.fireInspectionStateChanged();
        }
    }

    @Override
    public void addInspectionListener(InspectionListener inspectionListener) {
        this.listeners.add(InspectionListener.class, inspectionListener);
    }

    public void removeInspectionListener(InspectionListener inspectionListener) {
        this.listeners.remove(InspectionListener.class, inspectionListener);
    }

    @Override
    public void clearInspectionListener() {
        for (InspectionListener inspectionListener : (InspectionListener[])this.listeners.getListeners(InspectionListener.class)) {
            this.removeInspectionListener(inspectionListener);
        }
    }

    private void fireInspectionStateChanged() {
        InspectionEvent event = null;
        for (InspectionListener inspectionListener : (InspectionListener[])this.listeners.getListeners(InspectionListener.class)) {
            if (event == null) {
                event = new InspectionEvent(this, this.inspected);
            }
            inspectionListener.inspectionStateChanged(event);
        }
    }

    public long getRuntime() {
        return this.stopTime - this.startTime;
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        if (child.getNodeName().equals("startTime")) {
            this.startTime = Long.parseLong(child.getAttribute("value"));
        } else if (child.getNodeName().equals("stopTime")) {
            this.stopTime = Long.parseLong(child.getAttribute("value"));
        } else {
            super.addChild(child, documentFolder);
        }
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        if (child.getNodeName().equals("startTime")) {
            this.startTime = Long.parseLong(child.getAttribute("value"));
        } else if (child.getNodeName().equals("stopTime")) {
            this.stopTime = Long.parseLong(child.getAttribute("value"));
        } else {
            super.addChild(child, traceContainer);
        }
    }

    @Override
    public String getStereotype() {
        return null;
    }
}

