/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.Base64Tools;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestcaseWatch
implements TestcaseParameter {
    private String id;
    private File ioFile;
    private String diagramName;
    private String path;
    private String name;
    private String typeName;
    private int internalType;
    private Object value;
    private String displayValue;
    private boolean arrayItem = false;
    private boolean truncated = false;
    private boolean leaf = true;
    private volatile List<TestcaseWatch> items;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestcaseWatch(String id, File ioFile, String diagramName) {
        this.id = id;
        this.ioFile = ioFile;
        this.diagramName = diagramName;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(ioFile);
            InputStream in = zipFile.getInputStream(zipFile.getEntry(id));
            Document valueDocument = DomUtilities.parse((InputStream)in, (boolean)false, (boolean)false, (boolean)true);
            this.init((Element)valueDocument.getDocumentElement().getFirstChild());
            this.path = id;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public TestcaseWatch(TestcaseWatch parent, int index, Element element) {
        this(parent, index, element, false);
    }

    private TestcaseWatch(TestcaseWatch parent, int index, Element element, boolean arrayItem) {
        this.arrayItem = arrayItem;
        this.init(element);
        this.items = this.loadItems(element);
        this.path = (parent == null ? "" : parent.getName() + ".") + this.name + (index == -1 ? "" : "_" + index);
    }

    private TestcaseWatch(TestcaseWatch parent, int type) {
        this.internalType = type;
        this.value = null;
        this.displayValue = "";
        this.typeName = "";
        this.items = Collections.emptyList();
        this.path = (parent == null ? "" : parent.getName() + ".") + type;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isArrayItem() {
        return this.arrayItem;
    }

    @Override
    public String getDiagramName() {
        return this.diagramName;
    }

    @Override
    public Element createEmptyParameter(Document document) {
        return null;
    }

    public boolean isEmpty() {
        return this.internalType == 10009 || this.internalType == 10004 ? this.isLeaf() : this.value == null;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    private void init(Element element) {
        this.name = element.getNodeName();
        int index = this.name.indexOf("...");
        if (index != -1) {
            this.name = this.name.substring(0, index);
        }
        if ((index = this.name.indexOf("---")) != -1) {
            this.name = this.name.substring(0, index);
        }
        this.truncated = DomUtilities.getBooleanNS((Element)element, (String)"http://e2e.ch/bridge", (String)"truncated", (boolean)false);
        try {
            this.leaf = ((NodeList)DomUtilities.evaluate((Node)element, (String)"child::*", (QName)XPathConstants.NODESET)).getLength() == 0;
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        this.typeName = this.mapType(element);
        if (DomUtilities.getBooleanNS((Element)element, (String)"http://www.w3.org/2001/XMLSchema-instance", (String)"nil", (boolean)false)) {
            this.value = null;
        } else if (element.hasChildNodes()) {
            this.value = element.getFirstChild().getNodeValue();
            if (this.isBlob()) {
                this.value = Base64Tools.decodeToBytes((String)this.value.toString());
            }
        } else {
            this.value = this.isBlob() ? (Object)new byte[0] : "";
        }
        this.setDisplayValue(this.value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public boolean importValue(Object value) {
        this.setValue(value);
        return true;
    }

    @Override
    public boolean hasItems() {
        return !this.isLeaf();
    }

    public int getItemCount() {
        return this.getChildCount();
    }

    public TestcaseWatch getItem(int index) {
        return this.getItems().get(index);
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }

    private void setDisplayValue(Object value) {
        this.displayValue = value == null ? "<html><span style='color:#808080'>NULL</span></html>" : (this.isBlob() ? "<html><span style='color:#808080'>BLOB</span></html>" : "\"" + value + "\"");
    }

    @Override
    public String getValueAsString() {
        Object v = this.getValue();
        return v == null ? "NULL" : v.toString();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        return 17 + (this.path == null ? 0 : this.path.hashCode());
    }

    public boolean equals(Object other) {
        return this.path != null && other instanceof TestcaseWatch && this.path.equals(((TestcaseWatch)other).path);
    }

    private String mapType(Element element) {
        String type;
        if (element.hasAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType") || element.hasAttributeNS("http://www.w3.org/2003/05/soap-encoding", "arraySize")) {
            this.internalType = 10004;
            String arrayType = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            this.value = null;
            int index = arrayType.indexOf(58);
            type = arrayType.substring(index + 1);
        } else {
            switch (type = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
                case "Base Types.String": {
                    this.internalType = 10019;
                    break;
                }
                case "Base Types.Blob": {
                    this.internalType = 10005;
                    break;
                }
                case "Base Types.Boolean": {
                    this.internalType = 10006;
                    break;
                }
                case "Base Types.DateTime": {
                    this.internalType = 10010;
                    break;
                }
                case "Base Types.Float": {
                    this.internalType = 10011;
                    break;
                }
                case "Base Types.Integer": {
                    this.internalType = 10014;
                    break;
                }
                default: {
                    if (type.equals("Unknown") && this.isLeaf()) {
                        this.internalType = 10019;
                        type = "Base Types.String";
                        break;
                    }
                    if (!this.isLeaf() || type.length() > 0 && !type.equals("Unknown")) {
                        this.internalType = type.equals("Exception") ? 10048 : 10009;
                        this.value = null;
                        break;
                    }
                    this.internalType = 10019;
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TestcaseWatch> getItems() {
        List<TestcaseWatch> result = this.items;
        if (result == null) {
            TestcaseWatch testcaseWatch = this;
            synchronized (testcaseWatch) {
                result = this.items;
                if (result == null) {
                    result = this.items = this.loadItems();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TestcaseWatch> loadItems() {
        Element element = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.ioFile);
            ZipEntry entry = zipFile.getEntry(this.id);
            if (entry != null) {
                InputStream in = zipFile.getInputStream(entry);
                Document valueDocument = DomUtilities.parse((InputStream)in, (boolean)false, (boolean)false, (boolean)true);
                element = (Element)valueDocument.getDocumentElement().getFirstChild();
            } else if (Boolean.parseBoolean(System.getProperty("ch.e2e.builder.development"))) {
                System.err.printf("Can't find entry '%s' in %s.%n", this.id, this.ioFile);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.loadItems(element);
    }

    private List<TestcaseWatch> loadItems(Element element) {
        List<TestcaseWatch> result;
        if (element != null) {
            List<Element> children = this.getChildElements(element);
            result = new ArrayList<TestcaseWatch>(children.size());
            int i = 0;
            for (Element child : children) {
                result.add(new TestcaseWatch(this, i++, child, this.isArray()));
            }
            if (this.isArray() && this.isTruncated() && result.size() > 1) {
                result.add(1, new TestcaseWatch(this, 10045));
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<Element> getChildElements(Element element) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        int nNodes = nodes.getLength();
        for (int i = 0; i < nNodes; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            children.add((Element)node);
        }
        return children;
    }

    public Object getChild(int index) {
        return this.getItems().get(index);
    }

    @Override
    public boolean importData(Transferable t) {
        return false;
    }

    @Override
    public Transferable createTransferable() {
        Transferable t = null;
        if (this.value != null) {
            t = this.isBlob() ? new ParameterTransferHandler.BlobTransferable((byte[])this.value) : new StringSelection(this.value.toString());
        }
        return t;
    }

    public int getChildCount() {
        return this.getItems().size();
    }

    public int getIndexOfChild(Object child) {
        return this.getItems().indexOf(child);
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public boolean isSimpleType() {
        return !this.isComplex() && !this.isArray() && !this.isEllipsis();
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public boolean isArray() {
        return this.getType() == 10004;
    }

    @Override
    public boolean isEllipsis() {
        return this.getType() == 10045;
    }

    @Override
    public boolean isComplex() {
        return this.getType() == 10009;
    }

    @Override
    public boolean isDateTime() {
        return this.getType() == 10010;
    }

    @Override
    public boolean isBlob() {
        return this.getType() == 10005;
    }

    public int getType() {
        return this.internalType;
    }

    public String toString() {
        return this.getName();
    }
}

