/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.dom.DomUtilities;
import org.apache.commons.httpclient.Credentials;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractRequest {
    private String action;
    private Document response = null;
    private Exception exception = null;
    private Document request;
    private Credentials credentials;

    protected AbstractRequest(String action) {
        this(action, (Credentials)null);
    }

    protected AbstractRequest(String action, String classifier) {
        this(action, classifier, null);
    }

    protected AbstractRequest(String action, Credentials credentials) {
        this.action = action;
        this.credentials = credentials;
        this.createRequestDocument(action);
    }

    protected AbstractRequest(String action, String classifier, Credentials credentials) {
        this(action, credentials);
        Element classifierElement = this.request.createElement("classifier");
        classifierElement.appendChild(this.request.createTextNode(classifier));
        this.request.getDocumentElement().appendChild(classifierElement);
    }

    public abstract String getLocation();

    protected String getAction() {
        return this.action;
    }

    protected String getDocumentRoot() {
        return "trace";
    }

    public Document getRequest() {
        return this.request;
    }

    public Document getResponse() {
        return this.response;
    }

    public void setResponse(Document response) {
        this.response = response;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    private void createRequestDocument(String action) {
        this.request = DomUtilities.newDocument((String)this.getDocumentRoot());
        Element actionElement = this.request.createElement("action");
        actionElement.appendChild(this.request.createTextNode(action));
        this.request.getDocumentElement().appendChild(actionElement);
    }
}

