/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.util;

import com.mxgraph.util.mxRectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class mxGraphTransferable
implements Transferable,
UIResource,
Serializable {
    private static final long serialVersionUID = 5123819419918087664L;
    public static DataFlavor dataFlavor;
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;
    private static DataFlavor[] imageFlavors;
    protected Object[] cells;
    protected mxRectangle bounds;
    protected ImageIcon image;

    public mxGraphTransferable(Object[] objectArray, mxRectangle mxRectangle2) {
        this(objectArray, mxRectangle2, null);
    }

    public mxGraphTransferable(Object[] objectArray, mxRectangle mxRectangle2, ImageIcon imageIcon) {
        this.cells = objectArray;
        this.bounds = mxRectangle2;
        this.image = imageIcon;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public mxRectangle getBounds() {
        return this.bounds;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
        int n2 = this.isHtmlSupported() ? htmlFlavors.length : 0;
        int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
        int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
        int n5 = this.isImageSupported() ? stringFlavors.length : 0;
        int n6 = n + n2 + n3 + n4 + n5;
        DataFlavor[] dataFlavorArray2 = new DataFlavor[n6];
        int n7 = 0;
        if (n > 0) {
            System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n7, n);
            n7 += n;
        }
        if (n2 > 0) {
            System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n7, n2);
            n7 += n2;
        }
        if (n3 > 0) {
            System.arraycopy(plainFlavors, 0, dataFlavorArray2, n7, n3);
            n7 += n3;
        }
        if (n4 > 0) {
            System.arraycopy(stringFlavors, 0, dataFlavorArray2, n7, n4);
            n7 += n4;
        }
        if (n5 > 0) {
            System.arraycopy(imageFlavors, 0, dataFlavorArray2, n7, n5);
            n7 += n5;
        }
        return dataFlavorArray2;
    }

    protected DataFlavor[] getRicherFlavors() {
        return new DataFlavor[]{dataFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (dataFlavorArray[i] == null || !dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isRicherFlavor(dataFlavor)) {
            return this.getRicherData(dataFlavor);
        }
        if (this.isImageFlavor(dataFlavor)) {
            if (this.image != null && this.image.getImage() instanceof RenderedImage) {
                if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                    return this.image.getImage();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((Object)this.image.getImage()), "bmp", byteArrayOutputStream);
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        } else if (this.isHtmlFlavor(dataFlavor)) {
            String string = this.getHtmlData();
            String string2 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new ByteArrayInputStream(string.getBytes());
            }
        } else if (this.isPlainFlavor(dataFlavor)) {
            String string = this.getPlainData();
            String string3 = string = string == null ? "" : string;
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return string;
            }
            if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(string);
            }
            if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                return new ByteArrayInputStream(string.getBytes());
            }
        } else if (this.isStringFlavor(dataFlavor)) {
            String string = this.getPlainData();
            string = string == null ? "" : string;
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected boolean isRicherFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getRicherFlavors();
        int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(mxGraphTransferable.dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected boolean isHtmlFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = htmlFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHtmlSupported() {
        return false;
    }

    protected String getHtmlData() {
        return null;
    }

    protected boolean isImageFlavor(DataFlavor dataFlavor) {
        int n = imageFlavors != null ? imageFlavors.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!imageFlavors[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean isImageSupported() {
        return this.image != null;
    }

    protected boolean isPlainFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = plainFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return false;
    }

    protected String getPlainData() {
        return null;
    }

    protected boolean isStringFlavor(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = stringFlavors;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            mxGraphTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            mxGraphTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            mxGraphTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            mxGraphTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            mxGraphTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            mxGraphTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            mxGraphTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            mxGraphTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            imageFlavors = new DataFlavor[2];
            mxGraphTransferable.imageFlavors[0] = DataFlavor.imageFlavor;
            mxGraphTransferable.imageFlavors[1] = new DataFlavor("image/bmp");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
        }
        try {
            dataFlavor = new DataFlavor("application/x-java-serialized-object; class=com.mxgraph.swing.util.mxGraphTransferable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

