/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.substitutor;

import ch.e2e.util.StringTools;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import ch.e2e.xuml.utils.ClassFilter;
import ch.e2e.xuml.utils.ClassFinder;
import ch.e2e.xuml.utils.LineWithSeparatorReader;
import ch.e2e.xuml.utils.LineWithSeparatorReaderImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Map;

public class PlaceholderSubsitutorFactory {
    private static final String PACKAGE_NAME = PlaceholderSubsitutorFactory.class.getPackage().getName();
    private static final Class<?>[] SUBSTITUTOR_CLASSES;
    private static final DefaultSubstitutor DEFAULT_SUBSTITUTOR;

    private static Class<?>[] collectPlaceholderSubstitutorClasses() {
        ClassFinder classFinder = new ClassFinder(PACKAGE_NAME, new PlaceholderSubstitutorFilter());
        return classFinder.getClasses();
    }

    public static PlaceholderSubstitutor getSubstitutor(String filePath) {
        PlaceholderSubstitutor substitutor = PlaceholderSubsitutorFactory.findPlaceholderSubstitutor(filePath);
        return substitutor == null ? DEFAULT_SUBSTITUTOR : substitutor;
    }

    public static PlaceholderSubstitutor getDefaultSubstitutor() {
        return DEFAULT_SUBSTITUTOR;
    }

    private static PlaceholderSubstitutor findPlaceholderSubstitutor(String filePath) {
        for (Class<?> substitutorClass : SUBSTITUTOR_CLASSES) {
            try {
                PlaceholderSubstitutor substitutor = (PlaceholderSubstitutor)substitutorClass.newInstance();
                if (!substitutor.canProcess(filePath)) continue;
                return substitutor;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        DEFAULT_SUBSTITUTOR = new DefaultSubstitutor();
        SUBSTITUTOR_CLASSES = PlaceholderSubsitutorFactory.collectPlaceholderSubstitutorClasses();
    }

    private static class PlaceholderSubstitutorFilter
    implements ClassFilter {
        private PlaceholderSubstitutorFilter() {
        }

        @Override
        public boolean accept(Class<?> aClass) {
            return this.implementsPlaceholderSubstitutor(aClass) && this.canBeInstantiated(aClass) && !this.isInnerClassOfPlaceholderSubstitutorFactory(aClass);
        }

        private boolean implementsPlaceholderSubstitutor(Class<?> aClass) {
            return PlaceholderSubstitutor.class.isAssignableFrom(aClass);
        }

        private boolean canBeInstantiated(Class<?> aClass) {
            int classModifers = aClass.getModifiers();
            return !Modifier.isInterface(classModifers) && !Modifier.isAbstract(classModifers);
        }

        private boolean isInnerClassOfPlaceholderSubstitutorFactory(Class<?> aClass) {
            return aClass.getEnclosingClass() == PlaceholderSubsitutorFactory.class;
        }
    }

    static class DefaultSubstitutor
    implements PlaceholderSubstitutor {
        DefaultSubstitutor() {
        }

        @Override
        public boolean canProcess(String filePath) {
            return true;
        }

        @Override
        public void applySubstitutions(Reader reader, Writer writer, Map<String, String> substitutions) throws PlaceholderSubstitutorException {
            try {
                LineWithSeparatorReader lineReader = this.wrapReader(reader);
                if (this.hasSubstitutions(substitutions)) {
                    this.applySubstitutions(lineReader, writer, substitutions);
                } else {
                    this.copy(lineReader, writer);
                }
            }
            catch (IOException e) {
                throw new PlaceholderSubstitutorException(e);
            }
        }

        private LineWithSeparatorReader wrapReader(Reader reader) {
            return reader instanceof LineWithSeparatorReader ? (LineWithSeparatorReader)((Object)reader) : new LineWithSeparatorReaderImpl(reader);
        }

        private boolean hasSubstitutions(Map<String, String> substitutions) {
            return !substitutions.isEmpty();
        }

        private void applySubstitutions(LineWithSeparatorReader reader, Writer writer, Map<String, String> substitutions) throws IOException {
            String line;
            while ((line = reader.readLineWithSeparator()) != null) {
                this.applySubstitutions(line, writer, substitutions);
            }
        }

        private void applySubstitutions(String line, Writer writer, Map<String, String> substitutions) throws IOException {
            line = StringTools.replaceProperties((String)line, substitutions);
            this.write(line, writer);
        }

        private void copy(LineWithSeparatorReader reader, Writer writer) throws IOException {
            String line;
            while ((line = reader.readLineWithSeparator()) != null) {
                this.write(line, writer);
            }
        }

        private void write(String line, Writer writer) throws IOException {
            writer.write(line);
        }
    }
}

