/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.logging;

import ch.e2e.logging.LogManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public class Logging {
    public static void Initialize(File loggingFile) {
        Logging.Initialize(loggingFile, new Properties());
    }

    public static void Initialize(File loggingFile, Properties extraProperrties) {
        try {
            File defaultLoggingFile;
            Vector<InputStream> properties = new Vector<InputStream>();
            InputStream defaultStream = Logging.class.getResourceAsStream("logging.properties");
            if (defaultStream != null) {
                properties.add(defaultStream);
            }
            if ((defaultLoggingFile = new File(System.getProperty("user.home") + File.separator + ".e2ebuilder" + File.separator + "logging.properties")).exists()) {
                properties.add(new FileInputStream(defaultLoggingFile));
            }
            if (loggingFile.exists()) {
                properties.add(new FileInputStream(loggingFile));
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            extraProperrties.store(outStream, "");
            properties.add(new ByteArrayInputStream(outStream.toByteArray()));
            if (properties.size() > 0) {
                SequenceInputStream ins = new SequenceInputStream(properties.elements());
                LogManager.initialize((InputStream)ins);
                Logger logger = LogManager.getLogger((String)"e2e.ch.builder.base.logging");
                logger.info("E2E Logger Initialized");
            }
        }
        catch (IOException ioEx) {
            Logger.getLogger("global").severe("Caught a " + ioEx.getClass().getName() + ": " + ioEx.getMessage());
            Logger.getLogger("global").throwing(Logging.class.getName(), "Initialize", ioEx);
        }
    }
}

