/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.io;

import ch.e2e.builder.base.io.Logging;
import ch.e2e.builder.base.io.UniqueIdExtender;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UniqueIdService
implements Logging {
    private static final IgnoreCaseComparator ignoreCaseComparator = new IgnoreCaseComparator();

    private UniqueIdService() {
    }

    public static String createUniqueId(String originalString, String prefix, Map<String, String> uniqueIds) {
        TreeSet<String> ids = new TreeSet<String>(ignoreCaseComparator);
        ids.addAll(uniqueIds.values());
        int index = 0;
        String uniqueId = prefix;
        uniqueId = uniqueId.replace('-', '_');
        while (ids.contains(uniqueId)) {
            uniqueId = prefix + '_' + ++index;
            uniqueId = uniqueId.replace('-', '_');
        }
        uniqueIds.put(originalString, uniqueId);
        return uniqueId;
    }

    public static String createUniqueId(String originalString, Map<String, String> uniqueIds) {
        int hash = originalString.hashCode();
        String uniqueId = String.valueOf(hash);
        while (uniqueIds.containsValue(uniqueId)) {
            uniqueId = String.valueOf(++hash);
        }
        uniqueId = uniqueId.replace('-', '_');
        uniqueIds.put(originalString, uniqueId);
        return uniqueId;
    }

    public static HashMap<String, String> loadUniqueIds(File idFile) throws WrongIDFileVersionException {
        return UniqueIdService.loadUniqueIds(idFile, null);
    }

    public static HashMap<String, String> loadUniqueIds(File idFile, UniqueIdExtender extender) throws WrongIDFileVersionException {
        HashMap<String, String> uniqueIds = new HashMap<String, String>();
        if (idFile.exists()) {
            try {
                Document idDoc = DomUtilities.parse((File)idFile, (boolean)false, (boolean)false);
                NodeList ids = idDoc.getDocumentElement().getElementsByTagName("UniqueId");
                if (ids != null) {
                    int length = ids.getLength();
                    for (int i = 0; i < length; ++i) {
                        Element idElement = (Element)ids.item(i);
                        if (idElement.hasAttribute("original") && idElement.hasAttribute("id")) {
                            String original = idElement.getAttribute("original");
                            String id = idElement.getAttribute("id");
                            uniqueIds.put(original, id);
                            if (extender == null) continue;
                            extender.readExtendedInfo(idElement);
                            continue;
                        }
                        throw new WrongIDFileVersionException();
                    }
                }
            }
            catch (ParserConfigurationException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(UniqueIdService.class.getName(), "loadUniqueIds", e);
            }
            catch (SAXException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(UniqueIdService.class.getName(), "loadUniqueIds", e);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(UniqueIdService.class.getName(), "loadUniqueIds", e);
            }
        }
        return uniqueIds;
    }

    public static void saveIds(Map<String, String> uniqueIds, File idFile) {
        Document idDoc = DomUtilities.newDocument((String)"UniqueIds");
        for (String absolutePath : uniqueIds.keySet()) {
            Element uniqueIdElement = idDoc.createElement("UniqueId");
            uniqueIdElement.setAttribute("original", absolutePath);
            String uniqueId = uniqueIds.get(absolutePath);
            uniqueIdElement.setAttribute("id", uniqueId);
            idDoc.getDocumentElement().appendChild(uniqueIdElement);
        }
        idFile.getParentFile().mkdirs();
        try {
            DomUtilities.serialize((File)idFile, (Document)idDoc, (boolean)true);
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(UniqueIdService.class.getName(), "saveIds", e);
        }
    }

    public static void saveIds(Map<String, String> uniqueIds, OutputStream out, UniqueIdExtender extender, boolean close) {
        Document idDoc = DomUtilities.newDocument((String)"UniqueIds");
        for (String absolutePath : uniqueIds.keySet()) {
            Element uniqueIdElement = idDoc.createElement("UniqueId");
            uniqueIdElement.setAttribute("original", absolutePath);
            String uniqueId = uniqueIds.get(absolutePath);
            uniqueIdElement.setAttribute("id", uniqueId);
            if (extender != null) {
                extender.extendUniqueIdElement(uniqueIdElement);
            }
            idDoc.getDocumentElement().appendChild(uniqueIdElement);
        }
        try {
            DomUtilities.serialize((OutputStream)out, (Document)idDoc, (boolean)true, (boolean)close);
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(UniqueIdService.class.getName(), "saveIds", e);
        }
    }

    private static class IgnoreCaseComparator
    implements Comparator<String> {
        private IgnoreCaseComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

