/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.BuilderError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractBuilderError
implements BuilderError {
    @XmlAttribute
    private final String code;
    @XmlJavaTypeAdapter(value=ParameterMapAdapter.class)
    private Map<String, String> parameter;
    private long time;
    @XmlElement
    private String source;

    protected AbstractBuilderError(String code, Map<String, String> parameter) {
        this.parameter = parameter == null ? Collections.emptyMap() : parameter;
        this.code = code;
        this.time = new Date().getTime();
    }

    protected AbstractBuilderError(Element errorElement) {
        this.code = errorElement.getAttribute("code");
        this.source = errorElement.getAttribute("source");
        try {
            this.time = Long.parseLong(errorElement.getAttribute("time"));
        }
        catch (Exception e) {
            this.time = -1L;
        }
        this.readParameter(errorElement);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }

    @Override
    public String getTypeCode() {
        return "error.default";
    }

    @Override
    public Map<String, String> getTypeParameter() {
        return new HashMap<String, String>();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public String toString() {
        return this.getCode();
    }

    public Element toNode(Document parent) {
        Element errorElement = parent.createElement("Error");
        errorElement.setAttribute("type", this.getClass().getName());
        errorElement.setAttribute("code", String.valueOf(this.code));
        if (this.source != null && !this.source.isEmpty()) {
            errorElement.setAttribute("source", this.source);
        }
        if (System.getProperty("ch.e2e.builder.error.timestamp") != null && Boolean.getBoolean("ch.e2e.builder.error.timestamp")) {
            errorElement.setAttribute("time", String.valueOf(this.time));
        }
        if (this.parameter != null) {
            ArrayList<String> keys = new ArrayList<String>(this.parameter.keySet());
            keys.sort((o1, o2) -> -o1.compareTo((String)o2));
            for (String name : keys) {
                Element parameter = parent.createElement("Parameter");
                parameter.setAttribute("name", name);
                parameter.setAttribute("value", this.parameter.get(name));
                errorElement.appendChild(parameter);
            }
        }
        return errorElement;
    }

    public boolean equals(Object other) {
        return other instanceof AbstractBuilderError && this.equals((AbstractBuilderError)other);
    }

    public boolean equals(AbstractBuilderError error) {
        return (this.code == null && error.code == null || this.code != null && this.code.equals(error.code)) && (this.parameter == null || this.parameter.equals(error.parameter));
    }

    public int hashCode() {
        return (this.code + (this.parameter == null ? "no parameter" : this.parameter.toString())).hashCode();
    }

    @Override
    public Object getChild(int index) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    private void readParameter(Element errorElement) {
        this.parameter = new HashMap<String, String>();
        NodeList parameterList = errorElement.getElementsByTagName("Parameter");
        int length = parameterList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)parameterList.item(i);
            this.parameter.put(parameter.getAttribute("name"), parameter.getAttribute("value"));
        }
    }

    @Override
    public String getMessage() {
        return null;
    }

    static class ParameterMapAdapter
    extends XmlAdapter<ParameterWrapper, Map<String, String>> {
        private final Map<String, String> parameterMap = new HashMap<String, String>();

        ParameterMapAdapter() {
        }

        public Map<String, String> unmarshal(ParameterWrapper wrapper) {
            this.parameterMap.put(wrapper.name, wrapper.value);
            return this.parameterMap;
        }

        public ParameterWrapper marshal(Map<String, String> v) {
            throw new UnsupportedOperationException();
        }
    }

    static class ParameterWrapper {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String value;

        ParameterWrapper() {
        }
    }
}

