/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.regtest.model.TestImportTreeNode;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.response.AbstractResponseParser;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;

public class TraceTestcase
extends AbstractSynchronousTestcase
implements TestImportTreeNode {
    public static final int TESTCASE_SELECTABLE = 1000;
    public static final int TESTCASE_NOT_SELECTABLE = 1001;
    private boolean testSuiteSelectionMode;
    private int nameConflictOffset;
    private Collection<String> existingNames;
    private String testName;

    public TraceTestcase(String name, SynchronousTestcaseTemplate template, File home) {
        super(name, template, home);
        this.testName = name;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
        this.checkName(testName);
    }

    public boolean isLeaf() {
        return true;
    }

    public void setResponse(SOAPResponse response, boolean saveProperties) {
    }

    public AbstractResponseParser getResponseParser() {
        return null;
    }

    public boolean loadUmlTreeFromDisk() {
        return false;
    }

    public boolean isRun() {
        return this.getStatus() != 7;
    }

    public void copyReferenceData(String path) throws IOException {
        File traceFolder = this.getTraceFolder();
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        File referenceHome = new File(projectHome, "regressiontest/reference");
        File referenceFolder = new File(referenceHome, path + '/' + this.getTemplate().getFullQualifiedName() + '/' + this.getTestName());
        File from = new File(traceFolder, "request");
        if (from.exists()) {
            FileUtilities.copyFile((File)from, (File)new File(referenceFolder, "request"));
        }
        if ((from = new File(traceFolder, "request.log")).exists()) {
            FileUtilities.copyFile((File)from, (File)new File(referenceFolder, "request.log"));
        }
        if ((from = new File(traceFolder, "response")).exists()) {
            FileUtilities.copyFile((File)from, (File)new File(referenceFolder, "response"));
        }
        if ((from = new File(traceFolder, "response.log")).exists()) {
            FileUtilities.copyFile((File)from, (File)new File(referenceFolder, "response.log"));
        }
        if ((from = new File(traceFolder, "system.info")).exists()) {
            FileUtilities.copyFile((File)from, (File)new File(referenceFolder, "system.info"));
        }
    }

    public void saveProperties(File path) throws IOException {
        this.saveProperties(path, this.getProperties().getPropertiesFile().getName());
    }

    public void saveProperties(File path, String filename) throws IOException {
        this.fillProperties();
        File propertiesFile = new File(path, filename);
        Properties properties = new Properties(propertiesFile);
        properties.putAll((Map)this.getProperties());
        properties.write(false);
    }

    public int getType() {
        return this.isSelectable() ? 1000 + (this.hasNameConflict() ? this.nameConflictOffset : this.status) : 1001;
    }

    @Override
    public boolean isSelectable() {
        return !this.testSuiteSelectionMode && this.isRun();
    }

    @Override
    public void setTestSuitSelectionMode(boolean testSuiteSelectionMode) {
        this.testSuiteSelectionMode = testSuiteSelectionMode;
    }

    public List<TreePath> getSelectablePaths() {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (this.isSelectable()) {
            result.add(new TreePath(this));
        }
        return result;
    }

    @Override
    public void setExistingNames(Collection<String> existingNames) {
        this.existingNames = existingNames;
        this.checkName(this.getTestName());
    }

    @Override
    public void setExistingPaths(Collection<String> existingPaths, String rootPath) {
        this.existingNames = existingPaths;
        this.checkName(rootPath + this.getTestName());
    }

    @Override
    public void checkNames(String rootPath) {
        this.checkName(rootPath + this.getTestName());
    }

    private void checkName(String name) {
        this.nameConflictOffset = this.existingNames.contains(name) ? 150 : 0;
    }

    public boolean hasNameConflict(String name) {
        return this.existingNames.contains(name);
    }

    @Override
    public boolean hasNameConflict() {
        return this.nameConflictOffset != 0;
    }

    @Override
    public Collection<TraceTestcase> findNameConflicts() {
        ArrayList<TraceTestcase> result = new ArrayList<TraceTestcase>();
        if (this.hasNameConflict()) {
            result.add(this);
        }
        return result;
    }
}

