/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.resource.Properties;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.XMLDiffErrorDetail;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;

public class ErrorViewTreeModel
extends AbstractTreeModel {
    private ArrayList<Testcase> root = new ArrayList();

    public ErrorViewTreeModel() {
        super(new Properties("ch.e2e.builder.regtest.properties.tree"));
    }

    public Object getRoot() {
        return this.root;
    }

    public void clear() {
        this.root.clear();
        this.fireTreeStructureChanged(new TreePath(this.root));
    }

    public void addTestcase(Testcase testcase) {
        this.root.add(testcase);
        this.fireTreeStructureChanged(new TreePath(this.root));
    }

    public boolean isLeaf(Object node) {
        boolean result;
        boolean bl = result = !node.equals(this.root);
        if (node instanceof Testcase) {
            result = ((Testcase)node).getErrors().size() == 0;
        }
        return result;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public String getTypeString(int type) {
        return null;
    }

    public Object getChild(Object parent, int index) {
        Object result = parent instanceof Testcase ? ((Testcase)parent).getErrors().get(index) : (parent.equals(this.root) ? this.root.get(index) : super.getChild(parent, index));
        return result;
    }

    public int getChildCount(Object parent) {
        int result = parent instanceof Testcase ? ((Testcase)parent).getErrors().size() : (parent.equals(this.root) ? this.root.size() : super.getChildCount(parent));
        return result;
    }

    public int getType(Object value) {
        int result;
        if (value instanceof TestLogfile) {
            result = 20;
        } else if (value instanceof ErrorElement) {
            result = ((ErrorElement)value).getClassname().equals(AssertionFailedError.class.getName()) ? -10 : -11;
        } else if (value instanceof OptionContainer) {
            result = 600;
        } else if (value instanceof Testcase) {
            result = ((Testcase)value).getType();
            if (((Testcase)value).getErrors().size() > 0) {
                result += 2;
            } else if (((Testcase)value).isRun()) {
                ++result;
            }
        } else {
            result = super.getType(value);
        }
        return result;
    }

    public Object[][] getDefaultTypes() {
        return new Object[][]{{0, "regtest.root"}, {1, "regtest.testsuite"}, {2, "regtest.testsuite.in.library"}, {5, "regtest.library"}, {10, "regtest.testcase"}, {11, "regtest.testcase.no.errors"}, {12, "regtest.testcase.errors"}, {13, "regtest.testcase.in.library"}, {14, "regtest.testcase.in.library.no.errors"}, {15, "regtest.testcase.in.library.errors"}, {20, "regtest.logfile"}, {-10, "regtest.failure"}, {-11, "regtest.error"}, {500, "regtest.testsuite.options"}, {600, "regtest.option.container"}, {ErrorDetail.TYPE_ERROR_DETAIL, "error.detail"}, {XMLDiffErrorDetail.TYPE_XML_DIFF_ERROR_DETAIL, "error.xml.diff.detail"}};
    }
}

