/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEventMulticaster;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.test.options.Option;
import ch.e2e.util.StringTools;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JPanel;

public abstract class AbstractOptionPanel<T, U extends Option>
extends JPanel
implements OptionComponent<T, U> {
    private OptionInputChangedListener changedListener;
    private HashMap<String, String> optionProperties = new HashMap();
    private boolean fireOptionInputChanged = true;
    private boolean changed;
    private boolean ignoreRequired;

    protected AbstractOptionPanel() {
    }

    protected AbstractOptionPanel(LayoutManager layout) {
        super(layout);
    }

    protected AbstractOptionPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    protected AbstractOptionPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    @Override
    public void addOptionChangedListener(OptionInputChangedListener listener) {
        this.changedListener = OptionInputChangedEventMulticaster.addListener(this.changedListener, listener);
    }

    @Override
    public void removeOptionChangedListener(OptionInputChangedListener listener) {
        this.changedListener = OptionInputChangedEventMulticaster.removeListener(this.changedListener, listener);
    }

    public void fireOptionInputChanged() {
        if (this.fireOptionInputChanged && this.changedListener != null) {
            this.changedListener.optionChanged(new OptionInputChangedEvent(this, this.getOption().getKey(), this.getValue()));
        }
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public int getWeightY() {
        return 0;
    }

    @Override
    public void optionChanged(OptionInputChangedEvent event) {
        if (this.getOption().getValue() != null || !this.isEmpty()) {
            Object emptyDependsValue = this.getOption().createValue(StringTools.replaceProperties((String)this.getOption().getDependencyString(), this.optionProperties));
            this.fillOptionProperties(event);
            Object dependsValue = this.getOption().createValue(StringTools.replaceProperties((String)this.getOption().getDependencyString(), this.optionProperties));
            Object value = this.getValue();
            if (dependsValue.equals(value) || emptyDependsValue.equals(value)) {
                String valueStr = StringTools.replaceProperties((String)this.getOption().getDependencyString(), this.optionProperties);
                this.setValue(this.getOption().createValue(valueStr));
                this.setToolTipText(this.getOption().getDependencyString());
                this.fireOptionInputChanged();
            }
        }
    }

    @Override
    public final boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public boolean isIgnoreRequired() {
        return this.ignoreRequired;
    }

    @Override
    public void setIgnoreRequired(boolean ignoreRequired) {
        this.ignoreRequired = ignoreRequired;
    }

    private void fillOptionProperties(OptionInputChangedEvent event) {
        Object value = event.getValue();
        if (value != null) {
            String optionName = event.getKey();
            this.optionProperties.put(optionName, value.toString());
            String dependencyString = this.getOption().getDependencyString();
            if (dependencyString != null) {
                String extension = "";
                int index = dependencyString.indexOf("${" + optionName);
                while (index != -1) {
                    int endIndex = dependencyString.indexOf(125, index);
                    if (endIndex == -1) {
                        index = -1;
                        continue;
                    }
                    int dotIndex = index + optionName.length() + 2;
                    if (dotIndex < dependencyString.length() && dependencyString.charAt(dotIndex) == '.') {
                        String fieldName = dependencyString.substring(index + optionName.length() + 3, endIndex);
                        try {
                            Method getter;
                            String getterPostfix = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                            String getterName = "get" + getterPostfix;
                            try {
                                getter = value.getClass().getMethod(getterName, new Class[0]);
                            }
                            catch (NoSuchMethodException e) {
                                getterName = "is" + getterPostfix;
                                getter = value.getClass().getMethod(getterName, new Class[0]);
                            }
                            if (getter != null && !getter.getReturnType().getName().equals("void")) {
                                value = getter.invoke(value, new Object[0]);
                                extension = "." + fieldName;
                            }
                        }
                        catch (Exception e) {
                            value = null;
                        }
                    }
                    if (value != null) {
                        this.optionProperties.put(optionName + extension, value.toString());
                    }
                    index = dependencyString.indexOf("${" + optionName, index + optionName.length() + 3);
                }
            }
        }
    }

    public void setFireOptionInputChanged(boolean fireOptionInputChanged) {
        this.fireOptionInputChanged = fireOptionInputChanged;
    }

    @Override
    public void persist(boolean forced) {
        if ((!this.isEmpty() || this.getOption().getValue() != null) && (this.changed || forced && !this.getOption().isInherited())) {
            this.getOption().setValue(this.getValue());
            this.getOption().setInherited(false);
        }
    }
}

