/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSuiteChoicePanel;
import ch.e2e.builder.regtest.gui.TestSuiteSettings;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.swing.FixedHeightLabel;
import ch.e2e.test.Testable;
import ch.e2e.util.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;

public class TestSuiteToMoveSelection
extends E2EBuilderDialog {
    private static TestSuiteToMoveSelection selection;
    private String errorNameExists;
    private TestSuiteChoicePanel choicePanel;
    private FixedHeightLabel problem;
    private Testable testToMove;
    private String internalTitle;
    private String subtitle;

    public TestSuiteToMoveSelection(E2EBuilderModule module) {
        super(module.getTranslation("move.test.suite.title"), "", "", 3);
        this.internalTitle = module.getTranslation("move.test.suite.internaltitle");
        this.subtitle = module.getTranslation("move.test.suite.subtitle");
        this.createGui(module);
        this.errorNameExists = module.getTranslation("move.test.suite.error.name.exists");
    }

    public static TestSuiteToMoveSelection getInstance(E2EBuilderModule module) {
        if (selection == null) {
            selection = new TestSuiteToMoveSelection(module);
        }
        return selection;
    }

    public TestSuiteSettings selectTestSuiteToMoveTo(Testable testToMove, TreeTestSuite testSuiteToMoveTo) {
        String internalTitle = StringTools.replaceProperty((String)this.internalTitle, (String)"test.name", (String)testToMove.getName());
        this.setInternalTitle(internalTitle);
        String subtitle = StringTools.replaceProperty((String)this.subtitle, (String)"test.name", (String)testToMove.getName());
        this.setSubtitle(subtitle);
        this.testToMove = testToMove;
        TestSuiteSettings result = null;
        this.choicePanel.setTestSuite(testSuiteToMoveTo, true);
        this.checkOkButton();
        if (this.showDialog() == 1) {
            result = new TestSuiteSettings(this.choicePanel.getSelectedTestSuite(), this.choicePanel.getSelectionIndex());
        }
        return result;
    }

    public int getMinimumWidth() {
        return 330;
    }

    private void createGui(E2EBuilderModule module) {
        this.choicePanel = new TestSuiteChoicePanel(module);
        this.choicePanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 0, 10));
        this.add(this.choicePanel, "North");
        this.problem = new FixedHeightLabel();
        this.problem.setForeground(Color.RED);
        this.problem.setBorder(BorderFactory.createEmptyBorder(0, 14, 3, 5));
        this.add((Component)this.problem, "South");
        this.choicePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteToMoveSelection.this.checkOkButton();
            }
        });
    }

    private void checkOkButton() {
        boolean ok = !this.choicePanel.existsName(this.testToMove.getName()) || this.testToMove.getParent().equals(this.choicePanel.getSelectedTestSuite());
        this.setOkButtonEnabled(ok);
        if (ok) {
            this.problem.setText("");
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("test.name", this.testToMove.getName());
            properties.put("testsuite.name", this.choicePanel.getSelectedTestSuite().getName());
            String message = StringTools.replaceProperties((String)this.errorNameExists, properties);
            this.problem.setText(message);
        }
    }
}

