/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.gui.ProjectFileSystemView;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.regtest.gui.RenameAndImportNameInputDialog;
import ch.e2e.builder.regtest.gui.TestSelectionTreeView;
import ch.e2e.builder.regtest.gui.TestSuiteChoicePanel;
import ch.e2e.builder.regtest.gui.TestcaseReplaceSelectionDialog;
import ch.e2e.builder.regtest.model.SelectionTreeModel;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.TestableSettings;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.regtest.testsuite.TraceTestcaseRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.FixedHeightLabel;
import ch.e2e.swing.model.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TestSelectionDialog
extends E2EBuilderDialog
implements TreeSelectionListener,
ItemListener {
    private static TestSelectionDialog dialog;
    private TestSelectionTreeView treeView;
    private E2EBuilderModule module;
    private String errorNoSelection;
    private JComboBox projectBox;
    private ProjectFileFilter projectFileFilter;
    private boolean changesEnabled = false;
    private File browseFile;
    private ProjectBoxModel projectBoxModel;
    private Collection<File> additionalProjects;
    private TestSuiteChoicePanel choicePanel;
    private FixedHeightLabel problem;
    private JButton importRename;
    private boolean renameBeforeImport;

    private TestSelectionDialog(E2EBuilderModule module) {
        this(module.getTranslation("test.selection.dialog.title"), module.getTranslation("test.selection.dialog.internaltitle"), module.getTranslation("test.selection.dialog.subtitle"), false, module);
        this.setErrorNoSelection(module.getTranslation("test.selection.error.no.selection"));
    }

    protected TestSelectionDialog(String title, String internalTitle, String subtitle, boolean testSuiteSelection, E2EBuilderModule module) {
        super(title, internalTitle, subtitle, 3);
        this.module = module;
        this.createGui(testSuiteSelection);
        this.projectFileFilter = new ProjectFileFilter();
        this.browseFile = new File("Browse ...");
        this.additionalProjects = new ArrayList<File>();
    }

    public static TestSelectionDialog getInstance(E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new TestSelectionDialog(module);
        }
        return dialog;
    }

    public TestcaseListSelection selectTestcases(TreeTestSuite parent, int index) {
        this.choicePanel.setTestSuite(parent, index == 0);
        this.fillProjectBox();
        TestcaseListSelection result = null;
        Object selectedItem = this.projectBox.getSelectedItem();
        if (selectedItem instanceof File) {
            this.treeView.setProjectHome((File)selectedItem);
            this.setNewTestSuiteSelection();
        }
        this.treeView.clearSelection();
        this.treeView.expandAll();
        this.treeView.setMultiSelection(true);
        this.setNoSelection();
        this.renameBeforeImport = false;
        if (this.showDialog() == 1 || this.renameBeforeImport) {
            result = this.getTestcaseListSelection(index);
        }
        return result;
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    protected void setErrorNoSelection(String errorNoSelection) {
        this.errorNoSelection = errorNoSelection;
    }

    protected JComboBox getProjectBox() {
        return this.projectBox;
    }

    protected TestSuiteChoicePanel getChoicePanel() {
        return this.choicePanel;
    }

    public TestSelectionTreeView getTreeView() {
        return this.treeView;
    }

    protected boolean doOnOk() {
        this.saveProjects();
        return super.doOnOk();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() == null) {
            this.setNoSelection();
        } else {
            this.setOkButtonEnabled(true);
            if (this.importRename != null) {
                this.importRename.setEnabled(true);
            }
            this.setProblem("");
        }
    }

    protected void setNewTestSuiteSelection() {
        this.treeView.setExistingNames(this.choicePanel.getSelectedTestSuite());
    }

    protected void setNoSelection() {
        this.setOkButtonEnabled(false);
        if (this.importRename != null) {
            this.importRename.setEnabled(false);
        }
        this.setProblem(this.errorNoSelection);
    }

    protected void setProblem(String error) {
        this.problem.setText(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProjects() {
        File projects = this.getProjectsFile();
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(projects));
            for (File project : this.additionalProjects) {
                out.println(project.getAbsolutePath());
            }
            out.flush();
        }
    }

    private void createGui(boolean testSuiteSelection) {
        this.setLayout(new BorderLayout());
        JPanel north = new JPanel(new BorderLayout(5, 5));
        this.choicePanel = new TestSuiteChoicePanel(this.module);
        this.choicePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSelectionDialog.this.setNewTestSuiteSelection();
            }
        });
        north.add((Component)this.choicePanel, "North");
        north.add((Component)ComponentFactory.createLabel((String)"test.selection.dialog.select.from", (E2EBuilderModule)this.module), "West");
        this.projectBoxModel = new ProjectBoxModel();
        this.projectBox = new JComboBox(this.projectBoxModel);
        this.projectBox.setRenderer(new ProjectBoxCellRenderer());
        this.projectBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TestSelectionDialog.this.projectSelected();
                TestSelectionDialog.this.setNewTestSuiteSelection();
            }
        });
        north.add((Component)this.projectBox, "Center");
        north.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add(north, "North");
        this.treeView = new TestSelectionTreeView(this.module, testSuiteSelection, this.getSelectionTreeModel(this.module));
        this.treeView.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 5, 5), this.treeView.getBorder()));
        this.add(this.treeView, "Center");
        this.treeView.addTreeSelectionListener(this);
        this.treeView.addItemListener(this);
        this.problem = new FixedHeightLabel();
        this.problem.setForeground(Color.RED);
        this.problem.setBorder(BorderFactory.createEmptyBorder(0, 5, 3, 5));
        this.add((Component)this.problem, "South");
        this.addSelectButtons();
        this.setOkButtonText(this.module.getTranslation("test.selection.dialog.button.ok"));
    }

    protected void addSelectButtons() {
        this.importRename = ComponentFactory.createButton((String)"test.selection.dialog.button.import.rename", (E2EBuilderModule)this.module);
        this.importRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSelectionDialog.this.renameBeforeImport = true;
            }
        });
        this.insertButton(this.importRename, 0, true);
        JButton selectAll = ComponentFactory.createButton((String)"test.selection.dialog.button.select.all", (E2EBuilderModule)this.module);
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSelectionDialog.this.selectAll();
            }
        });
        this.addButton(selectAll, 2, false);
        JButton selectNone = ComponentFactory.createButton((String)"test.selection.dialog.button.select.none", (E2EBuilderModule)this.module);
        selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSelectionDialog.this.treeView.selectNone();
            }
        });
        this.addButton(selectNone, 2, false);
    }

    protected SelectionTreeModel getSelectionTreeModel(E2EBuilderModule module) {
        TraceTestcaseRoot root = new TraceTestcaseRoot(module.getProjectPool().getProjectHome());
        root.setTestSuitSelectionMode(false);
        return new SelectionTreeModel(root, module);
    }

    private void selectAll() {
        this.treeView.selectAll();
    }

    protected void projectSelected() {
        if (this.changesEnabled) {
            if (this.projectBox.getSelectedIndex() == 0) {
                this.browseForProject();
            } else {
                this.changeProject();
            }
        }
    }

    private void browseForProject() {
        File projectHome = this.module.getProjectPool().selectProjectFile();
        if (projectHome != null) {
            this.changesEnabled = false;
            projectHome = projectHome.getParentFile();
            this.projectBoxModel.add(projectHome);
            this.additionalProjects.add(projectHome);
            this.changesEnabled = true;
            this.projectBox.setSelectedItem(projectHome);
        }
    }

    private void changeProject() {
        File newProjectHome = (File)this.projectBox.getSelectedItem();
        if (!newProjectHome.equals(this.treeView.getProjectHome())) {
            this.treeView.setProjectHome(newProjectHome);
            this.setNoSelection();
        }
    }

    protected void fillProjectBox() {
        this.changesEnabled = false;
        File[] projectFolders = FileUtilities.getFileList((File)this.module.getProjectPool().getProjectHome().getParentFile(), (FileFilter)this.projectFileFilter);
        this.projectBoxModel.removeAll();
        this.projectBoxModel.add(this.browseFile);
        this.projectBoxModel.addAll(Arrays.asList(projectFolders));
        this.projectBox.setSelectedItem(this.treeView.getProjectHome());
        this.addAdditionalProjects();
        this.changesEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdditionalProjects() {
        this.additionalProjects.clear();
        File projects = this.getProjectsFile();
        if (projects.exists()) {
            BufferedReader projectsIn = null;
            try {
                projectsIn = new BufferedReader(new FileReader(projects));
                String line = projectsIn.readLine();
                while (line != null) {
                    File file = new File(line);
                    if (file.exists()) {
                        this.additionalProjects.add(file);
                    }
                    line = projectsIn.readLine();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (projectsIn != null) {
                    try {
                        projectsIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.projectBoxModel.addAll(this.additionalProjects);
        }
    }

    private File getProjectsFile() {
        File projectHome = this.module.getProjectPool().getProjectHome();
        File testSuiteFolder = new File(projectHome, "regressiontest/testsuite");
        return new File(testSuiteFolder, ".projects");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private TestcaseListSelection getTestcaseListSelection(int index) {
        TestcaseContainer[] selectedComponents = this.treeView.getSelectedObjects();
        ArrayList<TraceTestcase> existingTestcases = new ArrayList<TraceTestcase>();
        List<TraceTestcase> testcases = this.getSelectedTestcases(selectedComponents);
        for (TraceTestcase testcase : testcases) {
            if (!testcase.hasNameConflict()) continue;
            existingTestcases.add(testcase);
        }
        TestcaseListSelection result = new TestcaseListSelection(this.choicePanel.getSelectedTestSuite(), this.choicePanel.isVisible() ? this.choicePanel.getSelectionIndex() : index);
        result.setTestcases(testcases);
        if (existingTestcases.size() > 0) {
            List<TraceTestcase> testcasesToOverride = TestcaseReplaceSelectionDialog.getInstance(this.module).selectTestcasesToOverride(existingTestcases);
            if (testcasesToOverride == null) {
                result = null;
            } else {
                existingTestcases.removeAll(testcasesToOverride);
                testcases.removeAll(existingTestcases);
                result.setOverrideReferenceData(TestcaseReplaceSelectionDialog.getInstance(this.module).isOverrideRefernecData());
            }
        }
        return result;
    }

    private List<TraceTestcase> getSelectedTestcases(TestcaseContainer[] selectedComponents) {
        ArrayList<TraceTestcase> testcases = new ArrayList<TraceTestcase>(selectedComponents.length);
        for (TestcaseContainer testcase : selectedComponents) {
            if (this.renameBeforeImport) {
                String testName = RenameAndImportNameInputDialog.getInstance(this.module).getTestName((TraceTestcase)testcase);
                ((TraceTestcase)testcase).setTestName(testName);
            }
            testcases.add((TraceTestcase)testcase);
        }
        return testcases;
    }

    private class ProjectFileFilter
    extends E2EFileFilter
    implements FileFilter {
        private ProjectFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return ProjectFileSystemView.isProjectFolder((File)file);
        }

        public String getDescription() {
            return "Scheer PAS Builder Project";
        }

        public String getDefaultExtension() {
            return "e2ebuilder";
        }
    }

    private class ProjectBoxComparator
    implements Comparator<File> {
        private ProjectBoxComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.equals(TestSelectionDialog.this.browseFile) ? -1 : (o2.equals(TestSelectionDialog.this.browseFile) ? 1 : o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath()));
        }
    }

    private class ProjectBoxModel
    extends SortedListModel<File>
    implements ComboBoxModel {
        private Object selectedItem;

        private ProjectBoxModel() {
            super((Comparator)new ProjectBoxComparator());
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            this.selectedItem = selectedItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }

    private class ProjectBoxCellRenderer
    extends DefaultListCellRenderer {
        private ProjectBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result;
            if (value != null && value.equals(TestSelectionDialog.this.browseFile)) {
                result = super.getListCellRendererComponent((JList<?>)list, ((File)value).getName(), index, isSelected, cellHasFocus);
                this.setIcon(E2EBuilderIcons.FILE_OPEN_ICON);
            } else {
                result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(E2EBuilderIcons.PROJECT_ICON);
            }
            return result;
        }
    }

    public static class TestcaseListSelection
    extends TestableSettings {
        private List<TraceTestcase> testcases;

        public TestcaseListSelection(TreeTestSuite parent, int index) {
            super(parent, index);
        }

        public List<TraceTestcase> getTestcases() {
            return this.testcases;
        }

        public void setTestcases(List<TraceTestcase> testcases) {
            this.testcases = testcases;
        }
    }

    public static class TestcaseContainerSelection
    extends TestableSettings {
        private ImportTestcaseContainer testcaseContainer;

        public TestcaseContainerSelection(TreeTestSuite parent, int index) {
            super(parent, index);
        }

        public ImportTestcaseContainer getTestcaseContainer() {
            return this.testcaseContainer;
        }

        public void setTestcaseContainer(ImportTestcaseContainer testcaseContainer) {
            this.testcaseContainer = testcaseContainer;
        }
    }
}

