/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSuiteChoicePanel;
import ch.e2e.builder.regtest.testsuite.TestableSettings;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.builder.regtest.tools.TestClassFactory;
import ch.e2e.test.TestType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectTestActionDialog
extends E2EBuilderDialog {
    private JList list;
    private TestSuiteChoicePanel choicePanel;

    public SelectTestActionDialog(E2EBuilderModule module) {
        super(module.getTranslation("create.test.case.select.action.title"), module.getTranslation("create.test.case.select.action.internaltitle"), module.getTranslation("create.test.case.select.action.subtitle"), 3);
        this.createGui(module);
    }

    public TestActionSettings selectTestAction(TreeTestSuite parent, boolean showTestSuiteSelection) {
        TestActionSettings result = null;
        this.choicePanel.setTestSuite(parent, showTestSuiteSelection);
        this.setOkButtonEnabled(this.list.getSelectedValue() != null);
        if (this.showDialog() == 1) {
            result = new TestActionSettings(this.choicePanel.getSelectedTestSuite(), this.choicePanel.getSelectionIndex());
            result.setTestType((TestType)this.list.getSelectedValue());
        }
        return result;
    }

    public int getMinimumWidth() {
        return 300;
    }

    public int getMinimumHeight() {
        return 400;
    }

    private void createGui(E2EBuilderModule module) {
        this.setLayout(new BorderLayout());
        this.choicePanel = new TestSuiteChoicePanel(module);
        this.add(this.choicePanel, "North");
        Collection<TestType> testActions = TestClassFactory.getInstance().getTestActions().values();
        TreeSet<TestType> actionNames = new TreeSet<TestType>(testActions);
        TestType[] types = new TestType[actionNames.size()];
        actionNames.toArray(types);
        this.list = new JList<TestType>(types);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new TestTypeListCellRenderer());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectTestActionDialog.this.setOkButtonEnabled(SelectTestActionDialog.this.list.getSelectedValue() != null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SelectTestActionDialog.this.okDialog();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list, 20, 30);
        scrollPane.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 5, 5), scrollPane.getBorder()));
        this.add(scrollPane, "Center");
    }

    private class TestTypeListCellRenderer
    extends DefaultListCellRenderer {
        private TestTypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TestType && result instanceof JLabel) {
                ((JLabel)result).setIcon(((TestType)value).getIcon());
            }
            return result;
        }
    }

    public static class TestActionSettings
    extends TestableSettings {
        private TestType testType;

        public TestActionSettings(TreeTestSuite parent, int index) {
            super(parent, index);
        }

        public TestType getTestType() {
            return this.testType;
        }

        public void setTestType(TestType testType) {
            this.testType = testType;
        }
    }
}

