/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.jms.JMSInitialContext;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import ch.e2e.bridge.server.jms.impl.JMSMessageImpl;
import ch.e2e.bridge.server.jms.parameter.JMSBytesMessage;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.NamingException;

public class JMSBytesMessageImpl
extends JMSMessageImpl
implements JMSBytesMessage {
    private byte[] message = null;

    @Override
    public Message createMessage(Session session, JMSInitialContext initialContext) throws JMSException, NamingException {
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(this.getByteMessage());
        this.fillMessage(session, (Message)message, initialContext);
        return message;
    }

    @Override
    public void setByteMessage(byte[] message) {
        this.message = message;
    }

    @Override
    public byte[] getByteMessage() {
        return this.message;
    }

    @Override
    public void fillMessage(Session session, Message msg, JMSInitialContext initialContext) throws JMSException, NamingException {
        JMSAddOnHelper.assign(this, session, msg, initialContext);
    }

    @Override
    public void assignHeaderFromMessage(Message msg) throws JMSException {
        JMSAddOnHelper.assignFrom(this, msg);
    }

    @Override
    public void assignBodyFromMessage(Message msg) throws JMSException {
        JMSAddOnHelper.setBody(this, msg);
    }

    @Override
    public void setMessage(String message) {
        this.message = message.getBytes();
    }

    @Override
    public String getMessage() {
        return new String(this.message);
    }
}

