/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.AnalyzerRoot;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class TransactionLogsRoot
extends TransactionLogObject
implements AnalyzerRoot {
    private static final String FOLDER_NAME = "TransactionLogs";
    private Map<String, TransactionLog> children = new TreeMap<String, TransactionLog>();
    private File home;
    private String name;

    public TransactionLogsRoot() {
        this("ROOT");
    }

    public TransactionLogsRoot(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public String getFoldername() {
        return FOLDER_NAME;
    }

    public Map<String, TransactionLog> getChildren() {
        return this.children;
    }

    public Set<String> getTransactionLogNames() {
        return this.getChildren().keySet();
    }

    public void loadChild(File folder) throws IOException {
        this.add(new TransactionLog(folder));
    }

    public void addTransactionLog(String name, File file) {
        TransactionLog transactionLog;
        File transactionLogHome = new File(this.getHome(), name);
        if (transactionLogHome.exists()) {
            transactionLog = this.get(name);
            if (transactionLog != null) {
                this.delete(transactionLog);
            }
        } else {
            transactionLogHome.mkdirs();
        }
        try {
            transactionLog = new TransactionLog(file, transactionLogHome);
            this.add(transactionLog);
            transactionLog.getTraceFolder().mkdir();
            try {
                new ZipFile(file);
                FileUtilities.copyFile((File)file, (File)transactionLog.getLogFile());
            }
            catch (ZipException e) {
                ZipUtilities.zipFileOrDir((File)file, (File)transactionLog.getLogFile());
            }
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "addTransactionLog", e);
        }
    }

    public TransactionLog get(String name) {
        return this.getChildren().get(name);
    }

    private void add(TransactionLog transactionLog) {
        transactionLog.setParent(this);
        this.children.put(transactionLog.getFullName(), transactionLog);
    }

    public void delete(TransactionLog transactionLog) {
        this.getChildren().remove(transactionLog.getFullName());
        transactionLog.delete();
    }

    @Override
    public String getId() {
        return this.name;
    }

    public void projectChanged(E2EBuilderProject project) {
        this.setHome(new File(project.getProjectHome(), "testcase" + File.separator + this.getFoldername()));
        this.clear();
        this.loadChildren();
    }

    private void loadChildren() {
        File[] folders;
        for (File folder : folders = FileUtilities.getAllDirectories((File)this.getHome())) {
            try {
                this.loadChild(folder);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "loadChildren", e);
            }
        }
    }

    @Override
    public Object getChild(int index) {
        return index > -1 && index < this.getChildCount() ? this.getChildren().values().toArray()[index] : null;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        int index = -1;
        TransactionLog[] logs = this.getChildren().values().toArray(new TransactionLog[0]);
        for (int i = 0; index == -1 && i < logs.length; ++i) {
            if (!logs[i].equals(child)) continue;
            index = i;
        }
        return index;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    protected void clear() {
        for (TransactionLog log : this.children.values()) {
            log.clear();
        }
        this.children.clear();
    }

    @Override
    protected void delete() {
    }

    @Override
    public void projectOpened(E2EBuilderProject project) {
        this.projectChanged(project);
    }
}

