/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.Logging;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogCall;
import ch.e2e.builder.analyzer.model.TransactionLogLifeline;
import ch.e2e.dom.DomUtilities;
import ch.e2e.util.CalendarUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransactionLogStatistics
implements Logging {
    private static final int MAX_AVERAGE_THRESHOLD_MS = 2000;
    private static final int MAX_EXECUTION_THRESHOLD_MS = 5000;
    private Document document = DomUtilities.newDocument((String)"reportRoot");
    private Element rootElement;

    public TransactionLogStatistics(TransactionLog transactionLog) {
        this.createRootElement(transactionLog);
        this.createBackendsStatistics(transactionLog);
        this.createConfigurationStatistics(transactionLog);
    }

    private void createRootElement(TransactionLog transactionLog) {
        this.rootElement = this.document.getDocumentElement();
        this.rootElement.setAttribute("startDate", String.valueOf(transactionLog.getStart()));
        this.rootElement.setAttribute("endDate", String.valueOf(transactionLog.getStart()));
        this.rootElement.setAttribute("maxAverageThreshold_ms", String.valueOf(2000));
        this.rootElement.setAttribute("maxExecutionThreshold_ms", String.valueOf(5000));
    }

    private void createBackendsStatistics(TransactionLog transactionLog) {
        for (TransactionLogLifeline lifeline : transactionLog.getLifelines()) {
            if (!lifeline.isBackend().booleanValue()) continue;
            StatisticsEntry entry = new StatisticsEntry(lifeline.getName(), lifeline.getCalls());
            Element element = this.document.createElement("BackendSystemLine");
            element.setAttribute("name", entry.getName());
            element.setAttribute("startDate", CalendarUtilities.toISO8601((Date)entry.getStartDate()));
            element.setAttribute("endDate", CalendarUtilities.toISO8601((Date)entry.getEndDate()));
            this.appendChild("days", entry.getDays(), element);
            this.appendChild("requests", entry.getNumberOfCalls(), element);
            this.appendChild("requestsPerDay", entry.getCallsPerDay(), element);
            this.appendChild("failedRequests", entry.getNumberOfFailedCalls(), element);
            this.appendChild("percentageOfFailedRequests", Math.round(entry.getPercentageFailedCalls()), element);
            this.appendChild("minExecutionTime", entry.getMinExecutionTime(), element);
            this.appendChild("maxExecutionTime", entry.getMaxExecutionTime(), element);
            this.appendChild("averageExecutionTime", Math.round(entry.getAverageExecutionTime()), element);
            this.appendChild("requests_0_20", entry.getCallsByThreshold(0), element);
            this.appendChild("requests_20_100", entry.getCallsByThreshold(1), element);
            this.appendChild("requests_100_500", entry.getCallsByThreshold(2), element);
            this.appendChild("requests_500_2500", entry.getCallsByThreshold(3), element);
            this.appendChild("requests_2500_12500", entry.getCallsByThreshold(4), element);
            this.appendChild("requestsSlower12500", entry.getCallsByThreshold(5), element);
            this.appendChild("requests_0_20_perc", Math.round(entry.getPercentageCallsByThreshold(0)), element);
            this.appendChild("requests_20_100_perc", Math.round(entry.getPercentageCallsByThreshold(1)), element);
            this.appendChild("requests_100_500_perc", Math.round(entry.getPercentageCallsByThreshold(2)), element);
            this.appendChild("requests_500_2500_perc", Math.round(entry.getPercentageCallsByThreshold(3)), element);
            this.appendChild("requests_2500_12500_perc", Math.round(entry.getPercentageCallsByThreshold(4)), element);
            this.appendChild("requestsSlower12500_perc", Math.round(entry.getPercentageCallsByThreshold(5)), element);
            this.rootElement.appendChild(element);
        }
    }

    private void createConfigurationStatistics(TransactionLog transactionLog) {
        Element configuration = this.document.createElement("configuration");
        configuration.setAttribute("name", transactionLog.getName());
        this.createServiceCallsStatistics(transactionLog, configuration);
        this.document.getDocumentElement().appendChild(configuration);
    }

    private void createServiceCallsStatistics(TransactionLog transactionLog, Element parent) {
        for (TransactionLogLifeline lifeline : transactionLog.getLifelines()) {
            String type = null;
            if (lifeline.isService().booleanValue()) {
                type = "Service";
            } else if (lifeline.isPState().booleanValue()) {
                type = "PState";
            }
            if (type == null) continue;
            StatisticsEntry entry = new StatisticsEntry(lifeline.getName(), lifeline.getCalls());
            Element element = this.document.createElement("serviceCall");
            element.setAttribute("type", type);
            element.setAttribute("service", transactionLog.getName());
            element.setAttribute("name", entry.getName());
            element.setAttribute("startDate", CalendarUtilities.toISO8601((Date)entry.getStartDate()));
            element.setAttribute("endDate", CalendarUtilities.toISO8601((Date)entry.getEndDate()));
            this.appendChild("days", entry.getDays(), element);
            this.appendChild("requests", entry.getNumberOfCalls(), element);
            this.appendChild("requestsPerDay", entry.getCallsPerDay(), element);
            this.appendChild("failedRequests", entry.getNumberOfFailedCalls(), element);
            this.appendChild("percentageOfFailedRequests", Math.round(entry.getPercentageFailedCalls()), element);
            this.appendChild("minExecutionTime", entry.getMinExecutionTime(), element);
            this.appendChild("maxExecutionTime", entry.getMaxExecutionTime(), element);
            this.appendChild("averageExecutionTime", Math.round(entry.getAverageExecutionTime()), element);
            this.appendChild("maxExecDate", CalendarUtilities.toISO8601((Date)entry.getEndDate()), element);
            this.appendChild("maxExecID", entry.getLastRequestId(), element);
            parent.appendChild(element);
            for (Map.Entry<String, List<TransactionLogCall>> backendCall : lifeline.getBackendCalls().entrySet()) {
                StatisticsEntry backendEntry = new StatisticsEntry(backendCall.getKey(), (Collection<TransactionLogCall>)backendCall.getValue());
                Element subElement = this.document.createElement("backendCall");
                subElement.setAttribute("name", backendEntry.getName());
                subElement.setAttribute("startDate", CalendarUtilities.toISO8601((Date)backendEntry.getStartDate()));
                subElement.setAttribute("endDate", CalendarUtilities.toISO8601((Date)backendEntry.getEndDate()));
                subElement.setAttribute("type", backendCall.getValue().get(0).getLifelineName());
                subElement.setAttribute("parameter1", "param");
                this.appendChild("days", backendEntry.getDays(), subElement);
                this.appendChild("requests", backendEntry.getNumberOfCalls(), subElement);
                this.appendChild("requestsPerDay", backendEntry.getCallsPerDay(), subElement);
                this.appendChild("failedRequests", backendEntry.getNumberOfFailedCalls(), subElement);
                this.appendChild("percentageOfFailedRequests", Math.round(backendEntry.getPercentageFailedCalls()), subElement);
                this.appendChild("minExecutionTime", backendEntry.getMinExecutionTime(), subElement);
                this.appendChild("maxExecutionTime", backendEntry.getMaxExecutionTime(), subElement);
                this.appendChild("averageExecutionTime", Math.round(backendEntry.getAverageExecutionTime()), subElement);
                this.appendChild("maxExecDate", CalendarUtilities.toISO8601((Date)backendEntry.getEndDate()), subElement);
                this.appendChild("maxExecID", backendEntry.getLastRequestId(), subElement);
                this.appendChild("requests_0_20", backendEntry.getCallsByThreshold(0), subElement);
                this.appendChild("requests_20_100", backendEntry.getCallsByThreshold(1), subElement);
                this.appendChild("requests_100_500", backendEntry.getCallsByThreshold(2), subElement);
                this.appendChild("requests_500_2500", backendEntry.getCallsByThreshold(3), subElement);
                this.appendChild("requests_2500_12500", backendEntry.getCallsByThreshold(4), subElement);
                this.appendChild("requestsSlower12500", backendEntry.getCallsByThreshold(5), subElement);
                this.appendChild("requests_0_20_perc", Math.round(backendEntry.getPercentageCallsByThreshold(0)), subElement);
                this.appendChild("requests_20_100_perc", Math.round(backendEntry.getPercentageCallsByThreshold(1)), subElement);
                this.appendChild("requests_100_500_perc", Math.round(backendEntry.getPercentageCallsByThreshold(2)), subElement);
                this.appendChild("requests_500_2500_perc", Math.round(backendEntry.getPercentageCallsByThreshold(3)), subElement);
                this.appendChild("requests_2500_12500_perc", Math.round(backendEntry.getPercentageCallsByThreshold(4)), subElement);
                this.appendChild("requestsSlower12500_perc", Math.round(backendEntry.getPercentageCallsByThreshold(5)), subElement);
                element.appendChild(subElement);
            }
        }
    }

    private void appendChild(String name, Object value, Node parent) {
        Element child = this.document.createElement(name);
        child.setTextContent(String.valueOf(value));
        parent.appendChild(child);
    }

    public Document getDocument() {
        return this.document;
    }

    public void serialize(File file) {
        try {
            DomUtilities.serialize((File)file, (Document)this.document, (boolean)true);
        }
        catch (TransformerException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "serialize", e);
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "serialize", e);
        }
    }

    private static class StatisticsEntry {
        public static final int[] thresholds = new int[]{20, 100, 500, 2500, 12500};
        private String name;
        private Date startDate = null;
        private Date endDate;
        private int numberOfCalls = 0;
        private int numberOfFailedCalls = 0;
        private int[] callsByThreshold = new int[thresholds.length + 1];
        private int minExecutionTime = Integer.MAX_VALUE;
        private int maxExecutionTime = 0;
        private int totalExecutionTime = 0;
        private String lastRequestId;

        public StatisticsEntry(String name, Collection<TransactionLogCall> calls) {
            this.name = name;
            Arrays.fill(this.callsByThreshold, 0);
            for (TransactionLogCall call : calls) {
                this.add(call);
            }
        }

        public String getName() {
            return this.name;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public int getNumberOfFailedCalls() {
            return this.numberOfFailedCalls;
        }

        public int getMinExecutionTime() {
            return this.minExecutionTime;
        }

        public int getMaxExecutionTime() {
            return this.maxExecutionTime;
        }

        public int getTotalExecutionTime() {
            return this.totalExecutionTime;
        }

        public double getAverageExecutionTime() {
            int n = this.getNumberOfCalls() - this.getNumberOfFailedCalls();
            return n == 0 ? 0.0 : 1.0 * (double)this.getTotalExecutionTime() / (double)n;
        }

        public int getCallsPerDay() {
            long n = this.getDays();
            return n == 0L ? 0 : (int)((long)this.getNumberOfCalls() / n);
        }

        public double getPercentageFailedCalls() {
            return this.getNumberOfCalls() == 0 ? 0.0 : 100.0 * (double)this.getNumberOfFailedCalls() / (double)this.getNumberOfCalls();
        }

        public int getCallsByThreshold(int i) {
            return this.callsByThreshold[i];
        }

        public double getPercentageCallsByThreshold(int i) {
            int n = this.getNumberOfCalls() - this.getNumberOfFailedCalls();
            return n == 0 ? 0.0 : 100.0 * (double)this.getCallsByThreshold(i) / (double)n;
        }

        public String getLastRequestId() {
            return this.lastRequestId;
        }

        public long getDays() {
            return this.startDate == null || this.endDate == null ? -1L : CalendarUtilities.getDayDifference((Date)this.endDate, (Date)this.startDate) + 1L;
        }

        private void add(TransactionLogCall call) {
            ++this.numberOfCalls;
            if (call.hasFailed()) {
                ++this.numberOfFailedCalls;
            }
            if (this.startDate == null) {
                this.startDate = call.getStartDate();
            }
            this.endDate = call.getEndDate();
            int duration = call.getDuration();
            this.totalExecutionTime += duration;
            if (duration < this.minExecutionTime) {
                this.minExecutionTime = duration;
            }
            if (duration > this.maxExecutionTime) {
                this.maxExecutionTime = duration;
            }
            boolean found = false;
            for (int i = 0; !found && i < thresholds.length; ++i) {
                boolean bl = found = duration < thresholds[i];
                if (!found) continue;
                int n = i;
                this.callsByThreshold[n] = this.callsByThreshold[n] + 1;
            }
            if (!found) {
                int n = thresholds.length;
                this.callsByThreshold[n] = this.callsByThreshold[n] + 1;
            }
            this.lastRequestId = call.getRequestId();
        }
    }
}

