/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.tabfiles;

import ch.e2e.builder.base.tabfiles.Tabfile;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RuntimeTabfile
extends Tabfile {
    private String lastComment;
    private String[] columnNames = null;
    private boolean writeXml;

    public RuntimeTabfile(File runtimeTabfileFolder, String filename) {
        super(runtimeTabfileFolder, filename, (Tabfile.Row)null);
    }

    public RuntimeTabfile(File runtimeTabfileFolder, String filename, boolean writeXml) {
        super(runtimeTabfileFolder, filename, (Tabfile.Row)null);
        this.writeXml = writeXml;
    }

    @Override
    public Tabfile.Row getColumnNames() {
        if (super.getColumnNames() == null || this.hasChanged()) {
            this.readFile(this.file);
        }
        return super.getColumnNames();
    }

    public void append(File tabfile) {
        this.columnNames = null;
        if (tabfile.exists()) {
            this.readFile(tabfile);
        }
    }

    @Override
    public void print() throws IOException {
        if (this.writeXml) {
            Tabfile.Row[] rows = new Tabfile.Row[this.getRows().size()];
            this.getRows().toArray(rows);
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            Document tabfileDoc = DomUtilities.newDocument((String)"Tabfile");
            String[] elementNames = this.getColumnNames().getEntries();
            if (elementNames[0].startsWith("#")) {
                elementNames[0] = elementNames[0].substring(1);
            }
            this.fillDocument(tabfileDoc, rows, elementNames);
            try {
                DomUtilities.serialize((File)this.file, (Document)tabfileDoc, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (TransformerException tEx) {
                tEx.printStackTrace();
            }
        } else {
            super.print();
        }
    }

    private void fillDocument(Document tabfileDocument, Tabfile.Row[] rows, String[] elementNames) {
        Element root = tabfileDocument.getDocumentElement();
        for (int i = 0; i < rows.length; ++i) {
            this.appendRow(rows[i], root, tabfileDocument, elementNames);
        }
    }

    private void appendRow(Tabfile.Row row, Element root, Document tabfileDocument, String[] elementNames) {
        Element rowElement = tabfileDocument.createElement("Row");
        String[] values = row.getEntries();
        for (int i = 0; i < values.length; ++i) {
            Element value = tabfileDocument.createElement(elementNames[i]);
            Text text = tabfileDocument.createTextNode(values[i]);
            value.appendChild(text);
            rowElement.appendChild(value);
        }
        root.appendChild(rowElement);
    }

    private void readFile(File tabfile) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileUtilities.copy((InputStream)new FileInputStream(tabfile), (OutputStream)out);
            BufferedReader in = null;
            in = new BufferedReader(new StringReader(out.toString("UTF-8")));
            String line = in.readLine();
            while (line != null) {
                this.addRow(line);
                line = in.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addRow(String line) {
        if (line.charAt(0) == '#' && this.columnNames == null) {
            this.lastComment = line;
        } else if (line.charAt(0) != '#') {
            if (this.columnNames == null) {
                this.createColumnNames();
                if (super.getColumnNames() == null) {
                    String[] names = new String[this.columnNames.length];
                    for (int i = 0; i < names.length; ++i) {
                        names[i] = this.columnNames[i].trim();
                    }
                    super.setColumnNames(new Tabfile.Row(names));
                }
            }
            this.appendRow(this.createRow(line));
        }
    }

    private void createColumnNames() {
        ArrayList<String> names = new ArrayList<String>();
        int index = this.lastComment.indexOf(32);
        while (index != -1) {
            int endIndex = this.findFirstNonSpaceCharacter(this.lastComment, index);
            String title = this.lastComment.substring(0, endIndex);
            names.add(title);
            this.lastComment = this.lastComment.substring(endIndex);
            index = this.lastComment.indexOf(32);
        }
        names.add(this.lastComment);
        this.columnNames = new String[names.size()];
        names.toArray(this.columnNames);
    }

    private Tabfile.Row createRow(String line) {
        String[] row = new String[this.columnNames.length];
        if (this.columnNames.length > 2) {
            for (int i = 0; i < this.columnNames.length - 1; ++i) {
                row[i] = line.substring(0, this.columnNames[i].length()).trim();
                line = line.substring(this.columnNames[i].length());
            }
            row[this.columnNames.length - 1] = line;
        } else {
            for (int i = 0; i < row.length; ++i) {
                int index = line.indexOf(32);
                if (index == -1) {
                    row[i] = line;
                    continue;
                }
                row[i] = line.substring(0, index);
                line = line.substring(index + 1);
            }
        }
        return new Tabfile.Row(row);
    }

    private int findFirstNonSpaceCharacter(String line, int startIndex) {
        int length = line.length();
        for (int i = startIndex; i < length; ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return -1;
    }
}

