/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project.gui;

import ch.e2e.builder.base.project.ProjectFile;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class ProjectFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        File[] result = FileSystemView.getFileSystemView().getFiles(dir, useFileHiding);
        for (int i = 0; i < result.length; ++i) {
            if (!ProjectFileSystemView.isProjectFolder(result[i])) continue;
            result[i] = new ProjectFile(result[i]);
        }
        return result;
    }

    @Override
    public Icon getSystemIcon(File file) {
        return file instanceof ProjectFile ? E2EBuilderIcons.PROJECT_ICON : FileSystemView.getFileSystemView().getSystemIcon(file);
    }

    @Override
    public Boolean isTraversable(File file) {
        return file instanceof ProjectFile || ProjectFileSystemView.isProjectFolder(file) ? false : FileSystemView.getFileSystemView().isTraversable(file);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = this.createFileObject(containingDir, newFolderString);
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    public String getSystemDisplayName(File file) {
        return file instanceof ProjectFile ? file.getName() : FileSystemView.getFileSystemView().getSystemDisplayName(file);
    }

    public static boolean isProjectFolder(File file) {
        File projectFile = new File(file, ".e2ebuilder");
        return file.isDirectory() && projectFile.exists() && projectFile.isFile();
    }

    public boolean equals(Object obj) {
        return FileSystemView.getFileSystemView().equals(obj) || super.equals(obj);
    }
}

