/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.module;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.application.ModulePropertiesPool;
import ch.e2e.builder.base.application.ParentApplication;
import ch.e2e.builder.base.application.abstracts.ShowStatusEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.Logging;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventController;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.EventObject;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ModuleFactory
implements Logging {
    private TreeMap<String, E2EBuilderModule> modules = new TreeMap();
    private String loadMessage = E2EBuilderTranslator.getTranslation((String)"module.load", (String)"module.load");

    public ModuleFactory(ModulePropertiesPool propertiesPool, ParentApplication parentApplication) {
        File[] manifestFiles;
        File[] jarfiles = parentApplication.getModuleJarfiles();
        if (jarfiles != null) {
            for (File jarfile : jarfiles) {
                try {
                    JarFile jarFile = new JarFile(jarfile);
                    Manifest manifest = jarFile.getManifest();
                    String classname = manifest.getMainAttributes().getValue("Module-Class");
                    if (classname == null) continue;
                    System.setProperty("ch.e2e.builder.library.path", jarfile.getParentFile().getParent());
                    this.loadModule(manifest, propertiesPool, parentApplication.getModulePackagePrefix());
                }
                catch (IOException e) {
                    logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    logger.throwing(this.getClass().getName(), "<init>", e);
                }
            }
        }
        if ((manifestFiles = parentApplication.getManifestFiles()) != null) {
            for (File manifestFile : manifestFiles) {
                try {
                    this.loadModule(new Manifest(new FileInputStream(manifestFile)), propertiesPool, parentApplication.getModulePackagePrefix());
                }
                catch (IOException e) {
                    logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    logger.throwing(this.getClass().getName(), "<init>", e);
                }
            }
        }
    }

    public int getModuleCount() {
        return this.modules.size();
    }

    public Collection<E2EBuilderModule> getModules() {
        return this.modules.values();
    }

    public E2EBuilderModule getModule(String name) {
        return this.modules.get(name);
    }

    public ModuleInfo getFrameworkInfo() {
        return new ModuleInfo("E2EBuilder Framework");
    }

    private void loadModule(Manifest manifest, ModulePropertiesPool pool, String modulePackagePrefix) {
        Attributes attributes;
        String className;
        if (manifest != null && (className = (attributes = manifest.getMainAttributes()).getValue("Module-Class")) != null) {
            try {
                ModuleInfo moduleInfo = new ModuleInfo(manifest);
                String message = StringTools.replaceProperty((String)this.loadMessage, (String)"module title", (String)moduleInfo.getTitle());
                EventController.fire((EventObject)new ShowStatusEvent(this, null, message, "status_messages"));
                E2EBuilderModule module = this.createModule(className, moduleInfo, pool, modulePackagePrefix);
                this.modules.put(module.getTitle(), module);
            }
            catch (ClassNotFoundException cnfEx) {
                cnfEx.printStackTrace();
                String classname = this.getClass().getName();
                E2EBuilder.logger.severe("Caught a " + cnfEx.getClass().getName() + " in " + classname + ".loadModule");
                E2EBuilder.logger.throwing(classname, "loadModule", cnfEx);
            }
            catch (IllegalAccessException iaEx) {
                String classname = this.getClass().getName();
                E2EBuilder.logger.severe("Caught a " + iaEx.getClass().getName() + " in " + classname + ".loadModule");
                E2EBuilder.logger.throwing(classname, "loadModule", iaEx);
            }
            catch (InstantiationException iEx) {
                String classname = this.getClass().getName();
                E2EBuilder.logger.severe("Caught a " + iEx.getClass().getName() + " in " + classname + ".loadModule");
                E2EBuilder.logger.throwing(classname, "loadModule", iEx);
            }
            catch (Exception ex) {
                String classname = this.getClass().getName();
                E2EBuilder.logger.severe("Caught a " + ex.getClass().getName() + " in " + classname + ".loadModule");
                E2EBuilder.logger.throwing(classname, "loadModule", ex);
            }
        }
    }

    private E2EBuilderModule createModule(String className, ModuleInfo moduleInfo, ModulePropertiesPool propertiesPool, String modulePackagePrefix) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> moduleClass = Class.forName(className);
        Properties props = propertiesPool.getProperties(moduleInfo.getName(), moduleClass);
        Constructor<?> constructor = moduleClass.getConstructor(ModuleInfo.class, Properties.class, String.class);
        return (E2EBuilderModule)constructor.newInstance(moduleInfo, props, modulePackagePrefix);
    }
}

