/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.model;

import ch.e2e.builder.base.gui.model.EALStyleConstants;
import ch.e2e.builder.base.gui.model.EALSyntaxError;
import ch.e2e.builder.eal.ASTLocalDefinition;
import ch.e2e.builder.eal.EALNode;
import ch.e2e.builder.eal.EALParser;
import ch.e2e.builder.eal.EALToken;
import ch.e2e.builder.eal.ParseException;
import ch.e2e.builder.eal.TokenMgrError;
import ch.e2e.resource.Properties;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public abstract class EALDocument
extends DefaultStyledDocument {
    public static final Properties PROPERTIES = new Properties("ch.e2e.builder.base.properties.eal", EALDocument.class.getClassLoader());
    protected EALParser parser;

    public abstract EALNode parse(Reader var1) throws ParseException;

    public abstract EALNode parseLine(Reader var1) throws ParseException;

    public EALDocument() {
        this.addStyles();
        this.parser = new EALParser((Reader)new StringReader(""));
        this.parser.setTabSize(1);
    }

    public String getText() throws BadLocationException {
        return this.getText(0, this.getLength());
    }

    public String getText(Element element) throws BadLocationException {
        int startOffset = element.getStartOffset();
        int length = element.getEndOffset() - startOffset;
        return this.getText(startOffset, length);
    }

    public String getParagraphText(int pos) throws BadLocationException {
        Element paragraph = this.getParagraphElement(pos);
        int startOffset = paragraph.getStartOffset();
        int length = paragraph.getEndOffset() - startOffset;
        return this.getText(startOffset, length);
    }

    public String getParagraphTextUpTo(int pos) throws BadLocationException {
        Element paragraph = this.getParagraphElement(pos);
        int startOffset = paragraph.getStartOffset();
        int length = pos - startOffset;
        return this.getText(startOffset, length);
    }

    public EALParser getParser() {
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ASTLocalDefinition> getLocalVariables(int pos) {
        HashMap<String, ASTLocalDefinition> locals = new HashMap<String, ASTLocalDefinition>();
        Element root = this.getDefaultRootElement();
        int startLine = root.getElementIndex(0);
        int endLine = root.getElementIndex(pos) - 1;
        for (int i = startLine; i < endLine + 1; ++i) {
            Element line = root.getElement(i);
            int startOffs = line.getStartOffset();
            int length = line.getEndOffset() - startOffs;
            BufferedReader reader = null;
            this.parser.ReInitEALTokens();
            try {
                reader = EALDocument.getReader(this.getText(startOffs, length));
                this.parser.ReInit((Reader)reader);
                ASTLocalDefinition n = this.parser.LocalDefinition();
                locals.put(n.getName(), n);
                continue;
            }
            catch (BadLocationException badLocationException) {
                continue;
            }
            catch (ParseException parseException) {
                continue;
            }
            catch (Error error) {
                continue;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return locals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EALSyntaxError> checkSyntax() {
        ArrayList<EALSyntaxError> errors = new ArrayList<EALSyntaxError>();
        BufferedReader reader = null;
        try {
            reader = EALDocument.getReader(this.getText(0, this.getLength()));
            this.parse(reader);
        }
        catch (ParseException e) {
            errors.add(EALSyntaxError.newEalSyntaxError(e));
        }
        catch (TokenMgrError e) {
            errors.add(EALSyntaxError.newEalSyntaxError(e));
        }
        catch (Error e) {
            errors.add(EALSyntaxError.newEalSyntaxError(e));
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return errors;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str != null && str.length() > 0) {
            super.insertString(offs, str, a);
            this.color();
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.color();
    }

    public EALToken[] runParser(int pos) {
        EALToken[] result;
        try {
            result = this.runParser(this.getParagraphText(pos));
        }
        catch (BadLocationException e) {
            result = new EALToken[]{};
        }
        return result;
    }

    public EALToken[] runParserUpTo(int pos) {
        EALToken[] result;
        try {
            result = this.runParser(this.getParagraphTextUpTo(pos));
        }
        catch (BadLocationException e) {
            result = new EALToken[]{};
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EALToken[] runParser(String line) {
        BufferedReader reader = EALDocument.getReader(line);
        try {
            this.parseLine(reader);
        }
        catch (ParseException parseException) {
        }
        catch (Error error) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.parser.getEALTokens();
    }

    protected void color() {
        this.color(0);
    }

    public void highlightLine(int line, Color foreground, Color background) {
        Element root = this.getDefaultRootElement();
        int start = root.getElement(line).getStartOffset();
        int end = root.getElement(line).getEndOffset();
        this.setCharacterAttributes(start, end - start + 1, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void color(int startLine) {
        boolean replaceStyle = true;
        Element root = this.getDefaultRootElement();
        while (startLine > -1 && startLine < root.getElementCount()) {
            int offset = root.getElement(startLine).getStartOffset();
            int length = this.getLength() - offset;
            if (length == 0) {
                return;
            }
            BufferedReader reader = null;
            this.setCharacterAttributes(offset, length, this.getStyleFor(EALToken.Category.DEFAULT), replaceStyle);
            EALSyntaxError error = null;
            try {
                reader = EALDocument.getReader(this.getText(offset, length));
                this.parse(reader);
            }
            catch (ParseException e) {
                error = EALSyntaxError.newEalSyntaxError(e, (Document)this, startLine);
            }
            catch (TokenMgrError e) {
                error = EALSyntaxError.newEalSyntaxError(e, (Document)this, startLine);
            }
            catch (BadLocationException e) {
            }
            catch (Error e) {
                error = EALSyntaxError.newEalSyntaxError(e, (Document)this, startLine);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            for (EALToken t : this.parser.getEALTokens()) {
                if (error != null && t.getBeginLine() + startLine - 1 > error.getLine()) continue;
                int tokenLength = t.getEndColumn() - t.getBeginColumn() + 1;
                int line = t.getBeginLine() + startLine - 1;
                Style style = this.getStyleFor(t.getCategory());
                this.setCharacterAttributes(root.getElement(line).getStartOffset() + t.getBeginColumn() - 1, tokenLength, style, replaceStyle);
            }
            if (error == null || error.getLine() < 0) {
                startLine = -1;
            } else {
                this.markError(error);
                startLine = error.isMultiLine() ? (error.getLine() == startLine ? error.getLine() + 1 : error.getLine()) : error.getLine() + 1;
            }
            replaceStyle = false;
        }
    }

    private void markError(EALSyntaxError error) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        EALStyleConstants.setSquigglyUnderline(style, true);
        EALStyleConstants.setErrorDescription(style, error.getDescription());
        this.setCharacterAttributes(error.getOffset(), error.getLength(), style, false);
    }

    public static BufferedReader getReader(String text) {
        return new BufferedReader(new StringReader(text));
    }

    protected Style getStyleFor(EALToken.Category category) {
        return this.getStyle(category.toString());
    }

    protected void addStyles() {
        this.addStyle(EALToken.Category.COMMENT, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.comment.color"), PROPERTIES.getBoolean("eal.document.comment.bold"), PROPERTIES.getBoolean("eal.document.comment.italic"));
        this.addStyle(EALToken.Category.CONSTANT, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.constant.color"), PROPERTIES.getBoolean("eal.document.constant.bold"), PROPERTIES.getBoolean("eal.document.constant.italic"));
        this.addStyle(EALToken.Category.DEFAULT, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.default.color"), PROPERTIES.getBoolean("eal.document.default.bold"), PROPERTIES.getBoolean("eal.document.default.italic"));
        this.addStyle(EALToken.Category.FUNCTION, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.function.color"), PROPERTIES.getBoolean("eal.document.function.bold"), PROPERTIES.getBoolean("eal.document.function.italic"));
        this.addStyle(EALToken.Category.IDENTIFIER, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.identifier.color"), PROPERTIES.getBoolean("eal.document.identifier.bold"), PROPERTIES.getBoolean("eal.document.identifier.italic"));
        this.addStyle(EALToken.Category.KEYWORD, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.keyword.color"), PROPERTIES.getBoolean("eal.document.keyword.bold"), PROPERTIES.getBoolean("eal.document.keyword.italic"));
        this.addStyle(EALToken.Category.MACRO, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.macro.color"), PROPERTIES.getBoolean("eal.document.macro.bold"), PROPERTIES.getBoolean("eal.document.macro.italic"));
        this.addStyle(EALToken.Category.NUMBER, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.number.color"), PROPERTIES.getBoolean("eal.document.number.bold"), PROPERTIES.getBoolean("eal.document.number.italic"));
        this.addStyle(EALToken.Category.OPERATION, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.operation.color"), PROPERTIES.getBoolean("eal.document.operation.bold"), PROPERTIES.getBoolean("eal.document.operation.italic"));
        this.addStyle(EALToken.Category.OPERATOR, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.operator.color"), PROPERTIES.getBoolean("eal.document.operator.bold"), PROPERTIES.getBoolean("eal.document.operator.italic"));
        this.addStyle(EALToken.Category.STRING, PROPERTIES.getColor("eal.document.background.color"), PROPERTIES.getColor("eal.document.string.color"), PROPERTIES.getBoolean("eal.document.string.bold"), PROPERTIES.getBoolean("eal.document.string.italic"));
    }

    protected void addStyle(EALToken.Category category, Color bg, Color fg, boolean bold, boolean italic) {
        Style style = this.addStyle(category.toString(), this.getStyle("default"));
        StyleConstants.setBackground(style, bg);
        StyleConstants.setForeground(style, fg);
        StyleConstants.setBold(style, bold);
        StyleConstants.setItalic(style, italic);
    }

    public List<Statement> getStatements() {
        List<Statement> statements = Collections.emptyList();
        try {
            String text = this.getText();
            if (text != null) {
                statements = new ArrayList<Statement>();
                EALNode root = this.parse(EALDocument.getReader(text));
                for (int i = 0; i < root.jjtGetNumChildren(); ++i) {
                    EALNode node = (EALNode)root.jjtGetChild(i);
                    statements.add(new Statement(node.getStartLine() - 1, node.getEndLine() - 1, node.getStart() - 1, node.getEnd()));
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return statements;
    }

    public String getStatementNumber(int pos) {
        int elementIndex = this.getDefaultRootElement().getElementIndex(pos);
        if (elementIndex > -1) {
            int elementStartPos = this.getDefaultRootElement().getElement(elementIndex).getStartOffset();
            int i = 1;
            for (Statement statement : this.getStatements()) {
                if (statement.getStartLine() == elementIndex && pos < elementStartPos + statement.getEndPos()) {
                    return String.valueOf(i);
                }
                ++i;
            }
        }
        return "-";
    }

    public static class Statement {
        private int startLine;
        private int endLine;
        private int startPos;
        private int endPos;

        public Statement(int startLine, int endLine, int startPos, int endPos) {
            this.endPos = endPos;
            this.startPos = startPos;
            this.endLine = endLine;
            this.startLine = startLine;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

