/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.menu;

import ch.e2e.builder.base.event.ToggleMenuEvent;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.RadioButtonMenuItem;
import ch.e2e.swing.event.MenuEventObject;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class E2EBuilderRadioButtonMenuItem
extends RadioButtonMenuItem {
    String key;

    public E2EBuilderRadioButtonMenuItem(String key, Icon icon, final ToggleMenuEvent menuEvent) {
        super(icon, (MenuEventObject)menuEvent);
        this.setIcon(icon);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                menuEvent.setState(E2EBuilderRadioButtonMenuItem.this.isSelected());
            }
        });
        this.init(key);
    }

    E2EBuilderRadioButtonMenuItem(Icon icon, final ToggleMenuEvent menuEvent) {
        super(icon, (MenuEventObject)menuEvent);
        this.setIcon(icon);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                menuEvent.setState(E2EBuilderRadioButtonMenuItem.this.isSelected());
            }
        });
    }

    void init(String key) {
        this.key = key;
        this.setText(this.getTranslation());
        this.setActionCommand(key);
    }

    public void changeLanguage() {
        this.setText(this.getTranslation());
    }

    public void setText(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, ";");
        if (tokenizer.hasMoreTokens()) {
            super.setText(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                this.setMnemonic(tokenizer.nextToken().charAt(0));
                if (tokenizer.hasMoreTokens()) {
                    this.setAccelerator(KeyStroke.getKeyStroke(tokenizer.nextToken()));
                }
            }
        }
    }

    String getTranslation() {
        return E2EBuilderTranslator.getTranslation((String)this.key, (String)this.key);
    }
}

