/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.junit.TestUnit;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestSuite;

public class JUnitTestTreeModel
extends AbstractTreeModel {
    private static final int TYPE_TESTSUITE = 0;
    private static final int TYPE_TESTPASSED = 1;
    private static final int TYPE_TESTFAILURE = 2;
    private static final int TYPE_TESTERROR = 3;
    private Icon errorIcon;
    private Icon okIcon;
    private Icon failureIcon;
    private Icon testsuiteIcon;
    private TestUnit root;

    public JUnitTestTreeModel(TestUnit root) {
        super(new Properties());
        this.root = root;
        this.loadIcons();
    }

    public TestUnit getRoot() {
        return this.root;
    }

    public void setRoot(TestUnit root) {
        this.root = root;
        this.fireRootChanged();
    }

    public Object getChild(Object parent, int index) {
        E2ETestSuite result = null;
        if (parent.equals(this.root)) {
            result = this.root.get(index);
        } else if (parent instanceof TestSuite) {
            TestSuite suite = (TestSuite)parent;
            result = suite.testAt(index);
        }
        return result;
    }

    public int getChildCount(Object parent) {
        int childCount = 0;
        if (parent.equals(this.root)) {
            childCount = this.root.size();
        } else if (parent instanceof TestSuite) {
            TestSuite suite = (TestSuite)parent;
            childCount = suite.testCount();
        }
        return childCount;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int index = -1;
        if (parent.equals(this.root)) {
            index = this.root.indexOf((E2ETestSuite)child);
        } else if (parent instanceof TestSuite) {
            TestSuite suite = (TestSuite)parent;
            int i = 0;
            Enumeration e = suite.tests();
            while (index == -1 && e.hasMoreElements()) {
                if (child.equals(e.nextElement())) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    public boolean isLeaf(Object node) {
        boolean result = node.equals(this.root) ? this.root.size() == 0 : !(node instanceof TestSuite);
        return result;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("TreeModel.valueForPathChanged: not implemented");
    }

    public int getType(Object value) {
        int result = -1;
        if (value instanceof TestSuite) {
            result = 0;
        } else if (value instanceof Test) {
            Test test = (Test)value;
            if (this.root.isFailure(test)) {
                result = 2;
            } else if (this.root.isError(test)) {
                result = 3;
            } else if (this.root.wasRun(test)) {
                result = 1;
            }
        } else {
            result = super.getType(value);
        }
        return result;
    }

    public Icon getTypeIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        Icon result;
        switch (type) {
            case 0: {
                result = this.testsuiteIcon;
                break;
            }
            case 2: {
                result = this.failureIcon;
                break;
            }
            case 3: {
                result = this.errorIcon;
                break;
            }
            case 1: {
                result = this.okIcon;
                break;
            }
            default: {
                result = super.getTypeIcon(type, leaf, expanded, selected);
            }
        }
        return result;
    }

    public String getTypeString(int type) {
        return null;
    }

    public String getTooltip(Object value) {
        String result;
        if (!(value instanceof TestSuite) && value instanceof Test) {
            Test t = (Test)value;
            String s = "";
            if (this.root.isFailure(t)) {
                s = " - Failed";
            } else if (this.root.isError(t)) {
                s = " - Error";
            } else if (this.root.wasRun(t)) {
                s = " - Passed";
            }
            result = value.toString() + s;
        } else {
            result = super.getTooltip(value);
        }
        return result;
    }

    public JPopupMenu getPopupMenu(TreePath[] paths) {
        return super.getPopupMenu(paths);
    }

    private void loadIcons() {
        this.errorIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/error.gif", (boolean)true);
        this.okIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/ok.gif", (boolean)true);
        this.failureIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/failure.gif", (boolean)true);
        this.testsuiteIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/testunit.gif", (boolean)true);
    }
}

