/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.JUnitGuiRegistry;
import ch.e2e.ant.gui.junit.TestRunView;
import ch.e2e.resource.ImageLoader;
import ch.e2e.test.Testable;
import ch.e2e.test.junit.ListTestRunContext;
import java.awt.Font;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JUnitFailureRunView
implements TestRunView {
    private JList failureList = new JList();
    private ListTestRunContext runContext;

    public JUnitFailureRunView() {
        this.failureList.setFont(new Font("Dialog", 0, 12));
        this.failureList.setSelectionMode(0);
        this.failureList.setVisibleRowCount(5);
        this.failureList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JUnitFailureRunView.this.testSelected();
            }
        });
        JUnitGuiRegistry.getInstance().registerGui(this);
    }

    public void setRunContext(ListTestRunContext runContext) {
        this.failureList.setModel(runContext.getListModel());
        this.failureList.setCellRenderer(runContext.getListCellRenderer());
        this.runContext = runContext;
    }

    @Override
    public void activate() {
        this.testSelected();
    }

    public void testSelected(Testable test) {
        this.clear();
    }

    private void testSelected() {
        int index = this.failureList.getSelectedIndex();
        if (index != -1) {
            this.runContext.testSelected(this.failureList.getModel().getElementAt(index));
        }
    }

    @Override
    public void addTab(JTabbedPane pane) {
        JScrollPane scrollPane = new JScrollPane(this.failureList, 22, 32);
        ImageIcon errorIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/error.gif", (boolean)true);
        pane.addTab("Failures", errorIcon, scrollPane, "The list of failed tests");
    }

    @Override
    public void clear() {
        ListModel model = this.failureList.getModel();
        if (model != null && model instanceof DefaultListModel) {
            ((DefaultListModel)model).clear();
        }
    }
}

