/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathReplaceTask
extends Task {
    private String xpath;
    private File document;
    private ArrayList<Attribute> attributes = new ArrayList();
    private boolean failOnError = true;

    public void execute() throws BuildException {
        if (this.xpath == null) {
            throw new BuildException("The attribute 'xpath' must be specified.");
        }
        if (this.document == null) {
            throw new BuildException("The attribute 'document' must be specified.");
        }
        try {
            Document doc = DomUtilities.parse((Reader)new FileReader(this.document), (boolean)false, (boolean)false, (boolean)false);
            NodeList result = (NodeList)DomUtilities.evaluate((Node)doc.getDocumentElement(), (String)this.xpath, (QName)XPathConstants.NODESET);
            if (result.getLength() > 0) {
                if (this.attributes.size() > 0) {
                    this.replaceAttributes(result);
                }
                DomUtilities.serialize((File)this.document, (Document)doc, (boolean)true);
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException((Throwable)e);
            }
            e.printStackTrace();
        }
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    private void replaceAttributes(NodeList result) {
        int length = result.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = result.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            for (Attribute attribute : this.attributes) {
                Attribute newAttribute = new Attribute();
                newAttribute.name = attribute.name;
                newAttribute.value = attribute.value;
                if (!element.hasAttribute(attribute.name)) continue;
                String value = element.getAttribute(attribute.name);
                if (attribute.value == null) {
                    for (Replace replace : attribute.replaceDefinitions) {
                        value = value.replace(replace.value, replace.replaceWith);
                    }
                    newAttribute.value = value;
                }
                element.setAttribute(newAttribute.name, newAttribute.value);
            }
        }
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void setDocument(File document) {
        this.document = document;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public static class Replace {
        private String value;
        private String replaceWith;

        public void setValue(String value) {
            this.value = value;
        }

        public void setReplaceWith(String replaceWith) {
            this.replaceWith = replaceWith;
        }
    }

    public static class Attribute {
        private String name;
        private String value;
        private ArrayList<Replace> replaceDefinitions = new ArrayList();

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void addReplace(Replace replace) {
            this.replaceDefinitions.add(replace);
        }
    }
}

