/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class CvsReport
extends AbstractCvsTask {
    private static final NameSet[] DEFAULTEXCLUDES = new NameSet[]{new NameSet("**/*~"), new NameSet("**/#*#"), new NameSet("**/.#*"), new NameSet("**/%*%"), new NameSet("**/._*"), new NameSet("**/CVS"), new NameSet("**/CVS/**"), new NameSet("**/.cvsignore"), new NameSet("**/SCCS"), new NameSet("**/SCCS/**"), new NameSet("**/vssver.scc"), new NameSet("**/.svn"), new NameSet("**/.svn/**")};
    private static final String ADDED = "added";
    private static final String CONFLICT = "conflict";
    private static final String MODIFIED = "modified";
    private static final String UNKNOWN = "unknown";
    private static final String UPDATE = "update";
    private ArrayList fileTypes = new ArrayList();
    private String property;
    private boolean append = false;
    private boolean defaultExcludes = true;
    private boolean onlyDirs = false;
    private ArrayList excludes = new ArrayList();
    private ArrayList includes = new ArrayList();
    private boolean executing;

    public void execute() throws BuildException {
        this.executing = true;
        if (this.property == null) {
            throw new BuildException("The attribute 'property' must be defined.");
        }
        this.setCommand("-q -n up");
        this.setQuiet(false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setOutputStream(out);
        super.execute();
        String[] filenames = this.parseOutput(out.toString());
        if (filenames.length > 0) {
            NameSet[] excludePatterns = this.createArray(this.excludes);
            if (this.defaultExcludes) {
                this.addDefaultExcludes(excludePatterns);
            }
            if ((filenames = this.checkExcludes(filenames, excludePatterns)).length > 0) {
                NameSet[] includePatterns = this.createArray(this.includes);
                filenames = this.checkIncludes(filenames, includePatterns);
            }
        }
        String value = this.createFilenamesString(filenames);
        if (this.getProject().getProperty(this.property) != null && this.append) {
            value = this.getProject().getProperty(this.property).trim() + ' ' + value;
        }
        if (value.length() > 0 || this.getProject().getProperty(this.property) != null) {
            this.getProject().setProperty(this.property, value);
        }
        this.executing = false;
    }

    private String[] parseOutput(String cvsout) {
        BufferedReader in = new BufferedReader(new StringReader(cvsout));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            FileType[] types = new FileType[this.fileTypes.size()];
            this.fileTypes.toArray(types);
            block4: while ((line = in.readLine()) != null) {
                line = line.trim();
                for (int i = 0; i < types.length; ++i) {
                    if (!line.startsWith(types[i].type)) continue;
                    line = line.substring(2).trim();
                    lines.add(line);
                    continue block4;
                }
            }
            String[] filenames = new String[lines.size()];
            lines.toArray(filenames);
            String[] stringArray = filenames;
            return stringArray;
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void setCommand(String c) throws BuildException {
        if (!this.executing) {
            throw new BuildException("The attribute can not be set.");
        }
        super.setCommand(c);
    }

    public void setOnlyDirs(boolean onlyDirs) {
        this.onlyDirs = onlyDirs;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    public void setIncludes(String includes) {
        if (includes != null && includes.length() > 0) {
            this.addPatterns(includes, this.includes);
        }
    }

    public void setExcludes(String excludes) {
        if (excludes != null && excludes.length() > 0) {
            this.addPatterns(excludes, this.excludes);
        }
    }

    public void setFileType(String fileType) {
        this.fileTypes.add(new FileType(fileType));
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public NameSet createInclude() {
        NameSet ns = new NameSet();
        this.includes.add(ns);
        return ns;
    }

    public NameSet createExclude() {
        NameSet ns = new NameSet();
        this.excludes.add(ns);
        return ns;
    }

    public FileType createFileType() {
        FileType ft = new FileType();
        this.fileTypes.add(ft);
        return ft;
    }

    private void addPatterns(String tokenizedString, ArrayList patterns) {
        StringTokenizer tokenizer = new StringTokenizer(tokenizedString, " ,");
        while (tokenizer.hasMoreTokens()) {
            patterns.add(new NameSet(tokenizer.nextToken()));
        }
    }

    private void addDefaultExcludes(NameSet[] excludePatterns) {
        if (excludePatterns.length > 0) {
            NameSet[] dummy = excludePatterns;
            excludePatterns = new NameSet[dummy.length + DEFAULTEXCLUDES.length];
            System.arraycopy(dummy, 0, excludePatterns, 0, dummy.length);
            System.arraycopy(DEFAULTEXCLUDES, 0, excludePatterns, dummy.length, DEFAULTEXCLUDES.length);
        } else {
            excludePatterns = DEFAULTEXCLUDES;
        }
    }

    private String createFilenamesString(String[] filenames) {
        StringBuffer filenamesBuffer = new StringBuffer(100);
        for (int i = 0; i < filenames.length; ++i) {
            filenamesBuffer.append(filenames[i] + ' ');
        }
        return filenamesBuffer.toString().trim();
    }

    private NameSet[] createArray(ArrayList list) {
        NameSet[] array = new NameSet[list.size()];
        list.toArray(array);
        return array;
    }

    private String[] checkExcludes(String[] filenames, NameSet[] excludePatterns) {
        if (excludePatterns.length > 0) {
            ArrayList<String> checkedFiles = new ArrayList<String>();
            for (int i = 0; i < filenames.length; ++i) {
                boolean ok = true;
                for (int j = 0; j < excludePatterns.length; ++j) {
                    if (!SelectorUtils.matchPath((String)excludePatterns[j].name, (String)filenames[i], (boolean)true)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                checkedFiles.add(filenames[i]);
            }
            filenames = new String[checkedFiles.size()];
            checkedFiles.toArray(filenames);
        }
        return filenames;
    }

    private String[] checkIncludes(String[] filenames, NameSet[] includePatterns) {
        int i;
        ArrayList<String> checkedFiles;
        File cvsdest = this.getDest();
        if (cvsdest == null) {
            cvsdest = this.getProject().getBaseDir();
        }
        if (includePatterns.length > 0) {
            checkedFiles = new ArrayList<String>();
            block0: for (i = 0; i < filenames.length; ++i) {
                for (int j = 0; j < includePatterns.length; ++j) {
                    boolean matchPath = SelectorUtils.matchPath((String)includePatterns[j].name, (String)filenames[i], (boolean)true);
                    if (!matchPath) continue;
                    checkedFiles.add(filenames[i]);
                    continue block0;
                }
            }
            filenames = new String[checkedFiles.size()];
            checkedFiles.toArray(filenames);
        }
        if (this.onlyDirs) {
            checkedFiles = new ArrayList();
            for (i = 0; i < filenames.length; ++i) {
                File dir = new File(cvsdest, filenames[i]);
                if (!dir.isDirectory()) continue;
                checkedFiles.add(filenames[i]);
            }
            filenames = new String[checkedFiles.size()];
            checkedFiles.toArray(filenames);
        }
        return filenames;
    }

    public static class NameSet {
        private String name;

        public NameSet() {
        }

        private NameSet(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class FileType {
        private String type;

        public FileType(String type) {
            this.type = this.getTypeString(type);
        }

        public FileType() {
        }

        public void setType(String type) {
            this.type = this.getTypeString(type);
        }

        private String getTypeString(String fileType) {
            if (fileType.equals(CvsReport.UNKNOWN)) {
                return "? ";
            }
            if (fileType.equals(CvsReport.MODIFIED)) {
                return "M ";
            }
            if (fileType.equals(CvsReport.CONFLICT)) {
                return "C ";
            }
            if (fileType.equals(CvsReport.ADDED)) {
                return "A ";
            }
            if (fileType.equals(CvsReport.UPDATE)) {
                return "U ";
            }
            return "undefined";
        }
    }
}

