/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.watch;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.BlobViewerDialog;
import ch.e2e.builder.trace.gui.DateViewerDialog;
import ch.e2e.builder.trace.gui.TextDialog;
import ch.e2e.builder.trace.gui.TextEditor;
import ch.e2e.builder.trace.gui.TextViewer;
import ch.e2e.builder.trace.gui.watch.AbstractWatchTreeModel;
import ch.e2e.builder.trace.gui.watch.WatchRenderer;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class WatchPane
extends JScrollPane {
    private static final Dimension PREFERRED_SIZE = new Dimension(300, 100);
    private static final Color BACKGROUND = Color.WHITE;
    private WatchTreeModel treeModel;
    private Tree tree;
    private TextDialog textViewer;
    private BlobViewerDialog blobViewer;
    private final E2EBuilderModule module;

    public WatchPane(E2EBuilderModule module, Dialog owner, TestcaseParameter watch) {
        super(20, 30);
        this.module = module;
        this.createGui(owner);
        this.setWatch(watch);
    }

    public WatchPane(E2EBuilderModule module, Dialog owner) {
        this(module, owner, null);
    }

    public void setWatch(TestcaseParameter watch) {
        this.treeModel.setRoot(watch);
        this.tree.refresh();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private void createGui(Dialog owner) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(BACKGROUND);
        this.setOpaque(true);
        this.treeModel = new WatchTreeModel(this.module);
        this.tree = new Tree((AbstractTreeModel)this.treeModel, (TreeCellRenderer)new WatchRenderer(new RendererPreferences((AbstractTreeModel)this.treeModel)));
        this.tree.setShowsRootHandles(true);
        this.tree.setBackground(BACKGROUND);
        this.tree.setOpaque(true);
        this.setViewportView((Component)this.tree);
        this.textViewer = new TextDialog(owner, (TextEditor)new TextViewer(this.module), this.module.getTranslation("text.viewer.title"), 0);
        this.blobViewer = BlobViewerDialog.getDialog(this.module);
    }

    public class WatchPopup
    extends ModulePopupMenu {
        private String value;

        public WatchPopup(E2EBuilderModule module) {
            super(module);
            this.createGui();
        }

        public void setTestcaseParameter(TestcaseParameter parameter) {
            this.value = parameter.getValueAsString();
        }

        private void createGui() {
            JMenuItem copyItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.copy", (E2EBuilderModule)WatchPane.this.module);
            copyItem.addActionListener(e -> this.copyValue());
            this.add(copyItem);
            JMenuItem showItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.show", (E2EBuilderModule)WatchPane.this.module);
            showItem.addActionListener(e -> WatchPane.this.textViewer.showText(this.value));
            this.add(showItem);
        }

        private void copyValue() {
            StringSelection contents = new StringSelection(this.value);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, contents);
        }
    }

    private class WatchTreeModel
    extends AbstractWatchTreeModel {
        private TestcaseParameter root;
        private WatchPopup popup;
        private ShowValueAction showValueAction;

        public WatchTreeModel(E2EBuilderModule module) {
            super(module);
            this.popup = new WatchPopup(module);
            this.showValueAction = new ShowValueAction();
        }

        public Object getRoot() {
            return this.root;
        }

        public void setRoot(TestcaseParameter root) {
            this.root = root;
        }

        public JPopupMenu getPopupMenu(TreePath[] paths) {
            TestcaseParameter parameter;
            WatchPopup popup = null;
            if (paths != null && paths.length > 0 && (parameter = (TestcaseParameter)paths[0].getLastPathComponent()).isSimpleType()) {
                popup = this.popup;
                popup.setTestcaseParameter(parameter);
            }
            return popup;
        }

        @Override
        public ActionListener getExecuteAction(TreePath[] paths) {
            this.showValueAction.parameter = (TestcaseParameter)paths[0].getLastPathComponent();
            return this.showValueAction.parameter.isSimpleType() ? this.showValueAction : super.getExecuteAction(paths);
        }

        @Override
        public Object getChild(Object parent, int index) {
            return parent instanceof TestcaseParameter ? ((TestcaseParameter)parent).getChild(index) : super.getChild(parent, index);
        }

        @Override
        public int getChildCount(Object parent) {
            return parent instanceof TestcaseParameter ? ((TestcaseParameter)parent).getChildCount() : super.getChildCount(parent);
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof TestcaseParameter ? !((TestcaseParameter)node).hasItems() : super.isLeaf(node);
        }

        protected class ShowValueAction
        implements ActionListener {
            private TestcaseParameter parameter;

            protected ShowValueAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.parameter.isDateTime()) {
                    DateViewerDialog.getDialog(WatchTreeModel.this.getModule()).show(this.parameter.getValueAsString());
                } else if (this.parameter.isBlob()) {
                    WatchPane.this.blobViewer.show((byte[])this.parameter.getValue());
                } else {
                    WatchPane.this.textViewer.showText(this.parameter.getValueAsString(), this.parameter.isTruncated());
                }
            }
        }
    }
}

