/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.IteratorFlow;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.TransformerFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import ch.e2e.swing.MouseOverList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IteratedCell
extends UmlCell
implements CellWithContextMenu {
    public static IterationContextMenu contextMenu;
    private IterationModel iterationModel;
    private E2EBuilderModule module;
    private String label;

    public IteratedCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        if (!(userObject instanceof IteratorFlow)) {
            throw new IllegalArgumentException("userObject has to be of class IteratorFlow");
        }
        this.module = module;
        this.initialize();
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public IterationContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new IterationContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<IteratedCell> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    @Override
    public String toString() {
        return this.label;
    }

    private void initialize() {
        String stereotype;
        UmlGraphConstants.setRoundedCorners((Map)this.attributes, true);
        List iterations = ((IteratorFlow)this.userObject).getIterations();
        this.iterationModel = new IterationModel(iterations);
        if (iterations.isEmpty()) {
            this.label = null;
            stereotype = null;
        } else {
            IOUmlObject firstIteration = (IOUmlObject)iterations.get(0);
            this.label = firstIteration.getName();
            stereotype = firstIteration.getStereotype();
        }
        UmlGraphConstants.setStereotype((Map)this.attributes, stereotype);
        UmlGraphConstants.setRuntime((Map)this.attributes, null);
    }

    private static class IterationModel
    extends ArrayList<IOUmlObject>
    implements ListModel {
        private IterationModel(Collection<? extends IOUmlObject> c) {
            super(c);
        }

        @Override
        public int getSize() {
            return this.size();
        }

        public Object getElementAt(int index) {
            return this.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class IterationContextMenu
    extends ContextMenu<IteratedCell> {
        private MouseOverList iterations;

        public IterationContextMenu(IteratedCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(IteratedCell cell) {
            this.iterations.setModel((ListModel)cell.iterationModel);
            super.setCell(cell);
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.iterations"), !cell.iterationModel.isEmpty());
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<IteratedCell>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((IteratedCell)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.iterations = new MouseOverList((ListModel)((IteratedCell)this.getCell()).iterationModel);
            this.iterations.setSelectionMode(0);
            this.iterations.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    IOUmlObject selected = (IOUmlObject)iterations.getSelectedValue();
                    if (selected != null) {
                        if (selected instanceof TransformerFlow) {
                            Script script = ((TransformerFlow)selected).getScript();
                            if (script != null) {
                                EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///showScript?script=" + script.getIoId()));
                            }
                        } else {
                            EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///openActivity?activity=" + selected.getOriginalName()));
                        }
                        iterations.clearSelection();
                        this.setVisible(false);
                    }
                }
            });
            JMenu iterationMenu = new JMenu(this.getTranslation("uml.diagram.action.show.iterations"));
            iterationMenu.add((Component)this.iterations);
            this.add(iterationMenu);
        }
    }
}

