/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.DiagramPanel;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.gui.uml.UmlGraphFileCorruptException;
import ch.e2e.builder.trace.gui.uml.state.StateGraphBuilder;
import ch.e2e.builder.trace.gui.uml.state.TransitionEdge;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.uml.StateTransition;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;

public class StateDiagramPanel
extends DiagramPanel {
    public StateDiagramPanel(E2ETraceModule module) {
        this(module, "state.diagram");
    }

    protected StateDiagramPanel(E2ETraceModule module, String diagramName) {
        super(module, diagramName);
    }

    @Override
    protected Object getCell(Object root) {
        TreeNode result = null;
        if (root instanceof TreePath) {
            double y = 0.0;
            Object o = ((TreePath)root).getLastPathComponent();
            if (o instanceof Testcase && ((Testcase)o).getType() != 40) {
                Object[] p = ((TreePath)root).getPath();
                StateTransition transition = null;
                block0: for (int i = p.length - 1; transition == null && i > -1; --i) {
                    if (!(p[i] instanceof StateTransition)) continue;
                    transition = (StateTransition)p[i];
                    UmlGraph graph = this.getGraph();
                    for (Object cellObject : graph.getCells()) {
                        Object sourceObject;
                        UmlObject umlObject;
                        TransitionEdge edge;
                        Object userObject;
                        if (!(cellObject instanceof TransitionEdge) || !((userObject = (edge = (TransitionEdge)cellObject).getUserObject()) instanceof UmlObject)) continue;
                        for (umlObject = (UmlObject)userObject; umlObject != null && !(umlObject instanceof StateTransition); umlObject = umlObject.getParent()) {
                        }
                        if (!transition.equals(umlObject) || !((sourceObject = edge.getSource()) instanceof DefaultPort)) continue;
                        TreeNode sourceCell = ((DefaultPort)sourceObject).getParent();
                        if (!(sourceCell instanceof DefaultGraphCell)) continue block0;
                        result = sourceCell;
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected UmlGraph createGraph() {
        UmlTree tree;
        Testcase testcase = this.getTestcase();
        UmlGraph graph = null;
        if (testcase != null && (tree = testcase.getUmlTree()) != null) {
            File targetFolder = testcase.getGraphFolder();
            File target = new File(targetFolder, this.getDiagramName());
            UmlTree root = this.getDiagramName().equals("state.diagram") ? tree : tree.findChild(this.getDiagramName());
            StateGraphBuilder stateGraphBuilder = new StateGraphBuilder(testcase, (UmlObject)root, this.getModule());
            graph = stateGraphBuilder.getGraph();
            try {
                if (target.exists()) {
                    try {
                        graph.readLayout(target);
                    }
                    catch (UmlGraphFileCorruptException e) {
                        stateGraphBuilder.doLayout();
                        graph.saveLayout(target);
                    }
                } else {
                    targetFolder.mkdirs();
                    stateGraphBuilder.doLayout();
                    graph.saveLayout(target);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return graph;
    }
}

