/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.Logging;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.event.EventExecutionVetoException;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public abstract class DiagramPanel
extends JScrollPane
implements ProjectListener,
Logging {
    protected static final int MAX_NAME_LENGTH = 30;
    private Testcase testcase;
    private boolean dirty;
    private String uri = null;
    private UmlGraph graph;
    private E2ETraceModule module;
    private String diagramName;
    private long runDate = -1L;

    protected DiagramPanel(E2ETraceModule module, String diagramName) {
        this.module = module;
        this.diagramName = diagramName;
        this.createGui();
    }

    protected void showDiagram() {
        if (this.getTestcase() != null && this.isDirty()) {
            this.graph = this.createGraph();
            this.setViewportView((Component)((Object)this.graph));
            this.setDirty(false);
        }
    }

    public E2ETraceModule getModule() {
        return this.module;
    }

    public String getDiagramName() {
        return this.diagramName;
    }

    public Object getPrintableObject() {
        return this.getComponent();
    }

    public String getUri() {
        return this.uri;
    }

    public JComponent getComponent() {
        return this.graph;
    }

    protected UmlGraph getGraph() {
        return this.graph;
    }

    public void setActive(boolean value) {
    }

    public void setTestcase(Testcase testcase) {
        this.setDirty(this.isDirty() || testcase != null && (!testcase.equals((Object)this.testcase) || this.runDate != testcase.getRunDate()));
        this.testcase = testcase;
        this.runDate = testcase == null ? -1L : testcase.getRunDate();
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected String createPrettyName(String name) {
        int index = name.lastIndexOf(".graph");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public void saveDiagramLayout() {
        File targetFolder;
        if (this.testcase != null && (targetFolder = this.testcase.getGraphFolder()).exists()) {
            try {
                if (this.graph != null && this.graph.getRunDate() > this.testcase.getRunDate()) {
                    this.graph.saveLayout(new File(targetFolder, this.getDiagramName()));
                }
            }
            catch (FileNotFoundException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "", e);
            }
        }
    }

    protected Object getCell(Object root) {
        return null;
    }

    public void scrollToVisible(Object root) {
        Object cell = this.getCell(root);
        if (cell != null) {
            this.graph.setSelectionCell(cell);
            if (this.getVerticalScrollBar().isVisible()) {
                this.graph.scrollCellToVisible(cell);
            }
        }
    }

    protected void setViewPosition(Point point) {
        this.getViewport().setViewPosition(point);
    }

    protected abstract UmlGraph createGraph();

    protected Testcase getTestcase() {
        return this.testcase;
    }

    private void createGui() {
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
    }
}

