/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeInspector;
import ch.e2e.dom.DomUtilities;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.language.LanguageSpecManager;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractXmlCodeEditor
extends CodeEditor {
    public static final String XML_CODE_EDITOR_KEY = "ch.e2e.builder.trace.xml.editor";
    private AbstractXmlCodeInspector codeInspector;

    public AbstractXmlCodeEditor() {
        LanguageSpecManager.getInstance().getLanguageSpec("XML").configureCodeEditor((CodeEditor)this);
        this.customizeStyles();
    }

    public AbstractXmlCodeEditor(Boolean useCodeInspector) {
        this();
        this.setUseCodeInspector(useCodeInspector);
    }

    public abstract AbstractXmlCodeInspector createCodeInspector();

    protected abstract void addCodeInspector(AbstractXmlCodeInspector var1);

    protected abstract void removeCodeInspector(AbstractXmlCodeInspector var1);

    public static AbstractXmlCodeEditor createEditor(boolean useCodeInspector) {
        AbstractXmlCodeEditor codeEditor;
        try {
            String classname = System.getProperty(XML_CODE_EDITOR_KEY);
            Class<?> clazz = Class.forName(classname, true, AbstractXmlCodeEditor.class.getClassLoader());
            Constructor<?> constructor = clazz.getConstructor(Boolean.class);
            codeEditor = (AbstractXmlCodeEditor)((Object)constructor.newInstance(useCodeInspector));
        }
        catch (Throwable e) {
            codeEditor = new DefaultXmlCodeEditor();
        }
        return codeEditor;
    }

    public void setFontSize(int size) {
        this.setFont(this.getFont().deriveFont((float)size));
    }

    public Document getXmlDocument() throws IOException, SAXException, ParserConfigurationException {
        return DomUtilities.parse((Reader)new StringReader(this.getText()), (boolean)false, (boolean)false);
    }

    public boolean usesCodeInspector() {
        return this.codeInspector != null;
    }

    public void setUseCodeInspector(boolean use) {
        if (use) {
            if (this.codeInspector == null) {
                this.codeInspector = this.createCodeInspector();
            }
            if (this.codeInspector != null) {
                this.setAutoInspecting(true);
                this.addCodeInspector(this.codeInspector);
            }
        } else if (this.codeInspector != null) {
            this.removeCodeInspector(this.codeInspector);
        }
    }

    public AbstractXmlCodeInspector getCodeInspector() {
        return this.codeInspector;
    }

    public void addCodeInspectionListener(AbstractXmlCodeInspector.CodeInspectionListener listener) {
        if (this.codeInspector == null) {
            throw new IllegalStateException("Internal code inspector has to be active.");
        }
        this.codeInspector.addCodeInspectionListener(listener);
    }

    public void removeCodeInspectionListener(AbstractXmlCodeInspector.CodeInspectionListener listener) {
        if (this.codeInspector != null) {
            this.codeInspector.removeCodeInspectionListener(listener);
        }
    }

    private void customizeStyles() {
        SyntaxStyleSchema styles = this.getStyles();
        SyntaxStyle style = styles.getStyle(6);
        style.setFontStyle(0);
        style = styles.getStyle(7);
        style.setForeground(Color.BLACK);
        style = styles.getStyle(3);
        style.setForeground(new Color(0xCC6600));
        style = styles.getStyle(4);
        style.setForeground(new Color(0xCC6600));
    }

    private static class DefaultXmlCodeEditor
    extends AbstractXmlCodeEditor {
        private DefaultXmlCodeEditor() {
        }

        @Override
        public AbstractXmlCodeInspector createCodeInspector() {
            return null;
        }

        @Override
        protected void addCodeInspector(AbstractXmlCodeInspector codeInspector) {
        }

        @Override
        protected void removeCodeInspector(AbstractXmlCodeInspector codeInspector) {
        }
    }
}

