/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.splash;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ImageIcon;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.splash.SplashScreen;
import sun.misc.BASE64Encoder;

public class SplashTask
extends Task {
    private String imgurl = null;
    private String proxy = null;
    private String user = null;
    private String password = null;
    private String port = "80";
    private int showDuration = 5000;
    private boolean useProxy = false;
    private static SplashScreen splash = null;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask;

    public void setImageURL(String imgurl) {
        this.imgurl = imgurl;
    }

    public void setUseproxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setShowduration(int duration) {
        this.showDuration = duration;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        boolean success;
        block25: {
            block26: {
                if (splash != null) {
                    splash.setVisible(false);
                    this.getProject().removeBuildListener(splash);
                    splash.dispose();
                    splash = null;
                }
                this.log("Creating new SplashScreen", 3);
                InputStream in = null;
                if (this.imgurl != null) {
                    try {
                        URL url;
                        URLConnection conn = null;
                        if (this.useProxy && this.proxy != null && this.proxy.length() > 0 && this.port != null && this.port.length() > 0) {
                            this.log("Using proxied Connection", 4);
                            System.getProperties().put("http.proxySet", "true");
                            System.getProperties().put("http.proxyHost", this.proxy);
                            System.getProperties().put("http.proxyPort", this.port);
                            url = new URL(this.imgurl);
                            conn = url.openConnection();
                            if (this.user != null && this.user.length() > 0) {
                                String encodedcreds = new BASE64Encoder().encode(new String(this.user + ":" + this.password).getBytes());
                                conn.setRequestProperty("Proxy-Authorization", encodedcreds);
                            }
                        } else {
                            System.getProperties().put("http.proxySet", "false");
                            System.getProperties().put("http.proxyHost", "");
                            System.getProperties().put("http.proxyPort", "");
                            this.log("Using Direction HTTP Connection", 4);
                            url = new URL(this.imgurl);
                            conn = url.openConnection();
                        }
                        conn.setDoInput(true);
                        conn.setDoOutput(false);
                        in = conn.getInputStream();
                    }
                    catch (Throwable ioe) {
                        this.log("Unable to download image, trying default Ant Logo", 4);
                        this.log("(Exception was \"" + ioe.getMessage() + "\"", 4);
                    }
                }
                if (in == null) {
                    ClassLoader cl = (class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask == null ? (class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask = SplashTask.class$("org.apache.tools.ant.taskdefs.optional.splash.SplashTask")) : class$org$apache$tools$ant$taskdefs$optional$splash$SplashTask).getClassLoader();
                    in = cl != null ? cl.getResourceAsStream("images/ant_logo_large.gif") : ClassLoader.getSystemResourceAsStream("images/ant_logo_large.gif");
                }
                success = false;
                if (in == null) break block26;
                DataInputStream din = new DataInputStream(in);
                try {
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        while (true) {
                            void var5_10;
                            int data;
                            if ((data = din.read()) == -1) {
                                this.log("Got ByteArray, creating splash", 4);
                                try {
                                    ImageIcon img = new ImageIcon(bout.toByteArray());
                                    splash = new SplashScreen(img);
                                    success = true;
                                }
                                catch (Throwable e) {
                                    this.logHeadless(e);
                                }
                                break;
                            }
                            bout.write((byte)var5_10);
                        }
                        Object var8_13 = null;
                    }
                    catch (Exception e) {
                        throw new BuildException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    try {
                        din.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        if (!success) throw throwable;
                        throw new BuildException(ioe);
                    }
                }
                try {}
                catch (IOException ioe) {
                    if (success) {
                        throw new BuildException(ioe);
                    }
                    break block25;
                }
                din.close();
                break block25;
            }
            try {
                splash = new SplashScreen("Image Unavailable.");
                success = true;
            }
            catch (Throwable e) {
                this.logHeadless(e);
            }
        }
        if (!success) return;
        splash.setVisible(true);
        splash.toFront();
        this.getProject().addBuildListener(splash);
        try {
            Thread.sleep(this.showDuration);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void logHeadless(Throwable e) {
        this.log("failed to display SplashScreen, caught " + e.getClass().getName() + " with message: " + e.getMessage(), 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

