/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.XalanExecutor;

public class Xalan2Executor
extends XalanExecutor {
    private static final String aPack = "org.apache.xalan.";
    private static final String sPack = "com.sun.org.apache.xalan.";
    private TransformerFactory tfactory = TransformerFactory.newInstance();

    protected String getImplementation() throws BuildException {
        return this.tfactory.getClass().getName();
    }

    protected String getProcVersion(String classNameImpl) throws BuildException {
        try {
            if (classNameImpl.equals("org.apache.xalan.processor.TransformerFactoryImpl") || classNameImpl.equals("org.apache.xalan.xslt.XSLTProcessorFactory")) {
                return this.getXalanVersion("org.apache.xalan.processor.XSLProcessorVersion");
            }
            if (classNameImpl.equals("org.apache.xalan.xsltc.trax.TransformerFactoryImpl")) {
                return this.getXSLTCVersion("org.apache.xalan.xsltc.ProcessorVersion");
            }
            if (classNameImpl.equals("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl")) {
                return this.getXSLTCVersion("com.sun.org.apache.xalan.internal.xsltc.ProcessorVersion");
            }
            throw new BuildException("Could not find a valid processor version implementation from " + classNameImpl);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Could not find processor version implementation", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() throws Exception {
        String system_id = this.caller.getStylesheetSystemId();
        StreamSource xsl_src = new StreamSource(system_id);
        Transformer tformer = this.tfactory.newTransformer(xsl_src);
        DOMSource xml_src = new DOMSource(this.caller.document);
        OutputStream os = this.getOutputStream();
        try {
            tformer.setParameter("output.dir", this.caller.toDir.getAbsolutePath());
            StreamResult result = new StreamResult(os);
            tformer.transform(xml_src, result);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }
}

