package com.scheer.pas.simple;

/*
 * This is an example for a POJO which can be transferred between the xUML Runtime and the JVM.
 *
 * This implementation demonstrates several important concepts for such a class:
 *   - it must have a public no-args constructor
 *   - fields are declared private
 *   - each field has corresponding getter and setter methods
 *   - getters start with 'get' (boolean getters can start with 'is')
 *   - setters start with 'set'
 */

/**
 * Represents a person with attributes such as first name, last name, age, and marital status.
 * Provides methods to access and modify these attributes, as well as additional functionality
 * to retrieve the person's age with an ordinal suffix.
 */
public class Person {

    private String firstName;
    private String lastName;
    private int age;
    private boolean married;

    public Person() {
    }

    /**
     * Retrieves the first name of the person.
     *
     * @return The first name of the person.
     */
    public String getFirstName() {
        return firstName;
    }

    /**
     * Sets the first name of the person.
     *
     * @param firstName The first name to set for the person.
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /**
     * Retrieves the last name of the person.
     *
     * @return The last name of the person.
     */
    public String getLastName() {
        return lastName;
    }

    /**
     * Sets the last name of the person.
     *
     * @param lastName The last name to set for the person.
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /**
     * Retrieves the age of the person.
     *
     * @return The age of the person.
     */
    public int getAge() {
        return age;
    }

    /**
     * Sets the age of the person.
     *
     * @param age The age to set for the person.
     */
    public void setAge(int age) {
        this.age = age;
    }

    /**
     * Checks whether the person is married.
     *
     * @return true if the person is married, false otherwise.
     */
    public boolean isMarried() {
        return married;
    }

    /**
     * Updates the marital status of the person.
     *
     * @param married The marital status to set for the person.
     *                Pass true if the person is married, false otherwise.
     */
    public void setMarried(boolean married) {
        this.married = married;
    }

    /**
     * Returns the person's age with appropriate ordinal suffix (e.g., "20th", "21st", "22nd", "23rd", "24th")
     *
     * @return String representation of age with ordinal suffix
     */
    String getAgeWithSuffix() {
        return age + getOrdinalSuffix(age);
    }

    private String getOrdinalSuffix(int number) {
        if (number % 100 >= 11 && number % 100 <= 13) {
            return "th";
        }
        switch (number % 10) {
            case 1:
                return "st";
            case 2:
                return "nd";
            case 3:
                return "rd";
            default:
                return "th";
        }
    }

}
