/*
 * Copyright: Scheer PAS GmbH
 */

package com.scheer.pas.service;

import ch.e2e.bridge.server.BridgeJavaCallback;
import ch.e2e.bridge.server.XumlLibraryClass;

import java.io.InputStream;

/*
 * This is an example for a PAS xlib Java service callback. It specifies the operations
 * that must be implemented in the xUML model.
 *
 * This implementation demonstrates several important concepts of such an interface:
 *   - it must be annotated with {@code @XumlLibraryClass} to be recognized by the xUML Compiler
 *   - it must extend 'BridgeJavaCallback'
 */

/**
 * The SimpleHttpServerCallback interface defines the contract for handling
 * HTTP server requests and responses in conjunction with the SimpleHttpServer class.
 * It specifies the operations that must be implemented to provide configuration
 * details and facilitate response creation for incoming HTTP requests.
 * <p>
 * This interface is designed to be used in the context of the SimpleHttpServer,
 * allowing applications to define their own request-response handling logic.
 */
@XumlLibraryClass(name = "HttpServerCallback")
public interface SimpleHttpServerCallback extends BridgeJavaCallback {

    /**
     * Retrieves the port number on which the HTTP server will be bound.
     *
     * @return The port number for the HTTP server.
     */
    int getPort();

    /**
     * Creates the HTTP response body for a given request.
     *
     * @param requestMethod The HTTP request method (e.g., GET, POST, etc.).
     * @param requestUri The URI of the incoming HTTP request.
     * @param requestBody The input stream representing the body of the request.
     * @return A byte array containing the response body to be sent back to the client.
     */
    byte[] createResponseBody(String requestMethod, String requestUri, InputStream requestBody);

}
