/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.xslt;

import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.RequestElement;
import ch.e2e.bridge.server.xslt.XSLTLogger;
import ch.e2e.io.ZipUtilities;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class XSLTExtractUtilities {
    public static final String XSLT_GLOBAL_LIBRARY_PATH = "xslt/lib";
    public static final String XSLT_REPOSITORY_LIBRARY_PATH = "repository/xslt/lib";
    public static final String XSLT_SRC_PATH = "repository/xslt/src";

    public static void unpackXSLTArchives(ArrayList archives) {
        if (archives != null) {
            Properties extractProperties = new Properties(new File(new File(JavaVirtualMachine.getInstancesHome(), XSLT_GLOBAL_LIBRARY_PATH), ".extracted"));
            boolean extractRepository = XSLTExtractUtilities.extractRepository();
            File xsltSrcDir = new File(XSLT_SRC_PATH);
            if (!xsltSrcDir.exists()) {
                xsltSrcDir.mkdirs();
            }
            for (Object archive : archives) {
                try {
                    RequestElement archiveElement = (RequestElement)archive;
                    boolean deploy = Boolean.parseBoolean(archiveElement.getAttribute("deploy"));
                    if (deploy && extractRepository) {
                        XSLTExtractUtilities.extractXSLTArchive(archiveElement, xsltSrcDir);
                        continue;
                    }
                    XSLTExtractUtilities.extractXSLTArchive(archiveElement, xsltSrcDir, extractProperties);
                }
                catch (IOException e) {
                    XSLTLogger.getInstance().error("1", String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()), e);
                }
            }
            try {
                extractProperties.write(false);
            }
            catch (IOException e) {
                XSLTLogger.getInstance().error("1", String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractRepository() {
        File extractedFile;
        File repostoryFolder = new File(XSLT_REPOSITORY_LIBRARY_PATH);
        if (!repostoryFolder.exists()) {
            repostoryFolder.mkdirs();
        }
        boolean result = !(extractedFile = new File(repostoryFolder, ".extracted")).exists();
        FileWriter out = null;
        try {
            out = new FileWriter(extractedFile);
        }
        catch (IOException e) {
            XSLTLogger.getInstance().error("2", String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static void extractXSLTArchive(RequestElement archiveElement, File xsltSrcDir) throws IOException {
        File xsltFolder = new File(XSLT_REPOSITORY_LIBRARY_PATH);
        File archive = new File(xsltFolder, archiveElement.getAttribute("filename"));
        ZipUtilities.extract((File)archive, (File)xsltSrcDir);
    }

    private static void extractXSLTArchive(RequestElement archiveElement, File xsltSrcDir, Properties extractProperties) throws IOException {
        File xsltFolder = new File(JavaVirtualMachine.getInstancesHome(), XSLT_GLOBAL_LIBRARY_PATH);
        String filename = archiveElement.getAttribute("filename");
        long lastModified = extractProperties.getInteger(filename, 0L);
        File archive = new File(xsltFolder, filename);
        if (archive.lastModified() > lastModified) {
            ZipUtilities.extract((File)archive, (File)xsltSrcDir);
            extractProperties.setProperty(filename, lastModified);
        }
    }
}

