/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.ldap.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.session.Session;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

public class LDAPAttributeWrapper
extends Wrapper {
    private static final Class originalClass = Attribute.class;
    private boolean fill = false;
    private ArrayList<?> values;

    public LDAPAttributeWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    public LDAPAttributeWrapper(Session session) {
        super(session);
    }

    @Override
    public void fill(Object object) {
        if (object != null) {
            if (this.fill) {
                throw new CyclicDependencyException(originalClass);
            }
            Attribute attribute = (Attribute)object;
            this.setId(attribute.getID());
            try {
                this.setValues(attribute.getAll());
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    @Override
    protected String getFullQualifiedModelName() {
        return null;
    }

    @Override
    protected Object createObject() {
        BasicAttribute attribute = new BasicAttribute(this.getId());
        for (Object value : this.getValues()) {
            attribute.add(value);
        }
        return attribute;
    }

    private String getId() {
        StringItem stringItem = this.getRecordItem().getStringItem(0);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setId(String id) {
        this.setValue(0, id);
    }

    private ArrayList<?> getValues() {
        if (this.values == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(1);
            Object o = arrayItem.getValue();
            this.values = o instanceof String ? (ArrayList)arrayItem.fillArrayClassWithString(ArrayList.class) : (ArrayList)arrayItem.fillArrayClassWithInputStream(ArrayList.class, ByteArrayInputStream.class);
        }
        return this.values;
    }

    private void setValues(NamingEnumeration<?> values) {
        this.values = Collections.list(values);
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(1);
        if (this.values.size() > 0) {
            Object aValue = this.values.get(0);
            if (aValue instanceof String) {
                for (Object value : this.values) {
                    BlobItem blobItem = ItemFactory.createBlobItem(this.getSession());
                    blobItem.setValueFromByteArray(value.toString().getBytes());
                    arrayItem.addItem(blobItem);
                }
            } else if (aValue instanceof byte[]) {
                for (Object value : this.values) {
                    BlobItem blobItem = ItemFactory.createBlobItem(this.getSession());
                    blobItem.setValueFromByteArray((byte[])value);
                    blobItem.setValue(aValue);
                    arrayItem.addItem(blobItem);
                }
            } else {
                throw new UnsupportedOperationException("Type '" + aValue.getClass() + "' not supported for operation 'setValues'.");
            }
        }
    }
}

