/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.JMSInitialContext;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import ch.e2e.bridge.server.jms.impl.JMSTextMessageImpl;
import ch.e2e.bridge.server.jms.parameter.JMSTextMessage;
import ch.e2e.bridge.server.jms.wrapper.JMSMessageWrapper;
import ch.e2e.bridge.server.session.Session;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.naming.NamingException;

public class JMSTextMessageWrapper
extends JMSMessageWrapper
implements JMSTextMessage {
    private Class originalClass = JMSTextMessageImpl.class;
    private boolean fill = false;

    public JMSTextMessageWrapper(Session session) {
        super(session);
    }

    public JMSTextMessageWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    @Override
    public Message createMessage(javax.jms.Session session, JMSInitialContext initialContext) throws JMSException, NamingException {
        TextMessage message = session.createTextMessage(this.getMessage());
        this.fillMessage(session, (Message)message, initialContext);
        return message;
    }

    @Override
    public void fill(Object object) {
        if (object != null) {
            if (this.fill) {
                throw new CyclicDependencyException(this.originalClass);
            }
            this.fill = true;
            super.fill(object);
            JMSTextMessageImpl value = (JMSTextMessageImpl)object;
            this.setMessage(value.getMessage());
            this.fill = false;
        }
    }

    @Override
    protected Object createObject() {
        JMSTextMessageImpl result = new JMSTextMessageImpl();
        result.setMessage(this.getMessage());
        this.toObject(result);
        return result;
    }

    @Override
    public String getMessage() {
        StringItem stringItem = this.getRecordItem().getStringItem(19);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    @Override
    public void setMessage(String value) {
        this.setValue(19, value);
    }

    @Override
    public void fillMessage(javax.jms.Session session, Message msg, JMSInitialContext initialContext) throws JMSException, NamingException {
        JMSAddOnHelper.assign(this, session, msg, initialContext);
    }

    @Override
    public void assignHeaderFromMessage(Message msg) throws JMSException {
        JMSAddOnHelper.assignFrom(this, msg);
    }

    @Override
    public void assignBodyFromMessage(Message msg) throws JMSException {
        JMSAddOnHelper.setBody(this, msg);
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.JMS.JMSStringMessage";
    }
}

