/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.parameter.JMSSendParameter;
import ch.e2e.bridge.server.session.Session;

public class JMSSendParameterWrapper
extends Wrapper {
    private Class originalClass = JMSSendParameter.class;
    private boolean fill = false;

    public JMSSendParameterWrapper(Session session) {
        super(session);
    }

    public JMSSendParameterWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    @Override
    public void fill(Object object) {
        if (this.fill) {
            throw new CyclicDependencyException(this.originalClass);
        }
        this.fill = true;
        JMSSendParameter value = (JMSSendParameter)object;
        this.setDestinationName(value.getDestinationName());
        this.setTimeToLive(value.getTimeToLive());
        this.fill = false;
    }

    @Override
    public Object createObject() {
        JMSSendParameter result = new JMSSendParameter();
        result.setDestinationName(this.getDestinationName());
        result.setTimeToLive(this.getTimeToLive());
        return result;
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.JMS.JMSSendParameter";
    }

    private String getDestinationName() {
        StringItem stringItem = this.getRecordItem().getStringItem(0);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setDestinationName(String value) {
        this.setValue(0, value);
    }

    private long getTimeToLive() {
        return this.longValue(1);
    }

    private void setTimeToLive(long value) {
        this.setValue(1, value);
    }
}

