/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.MapEntry;
import ch.e2e.bridge.server.MapEntryWrapper;
import ch.e2e.bridge.server.dataitem.FloatItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.session.Session;

public class DoubleMap
extends MapEntryWrapper {
    private Class originalClass = MapEntry.class;
    private boolean fill = false;

    public DoubleMap(Session session) {
        super(session);
    }

    public DoubleMap(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    @Override
    public void fill(Object object) {
        if (this.fill) {
            throw new CyclicDependencyException(this.originalClass);
        }
        this.fill = true;
        MapEntry value = (MapEntry)object;
        this.setKey((String)value.getKey());
        this.setValue((Double)value.getValue());
        this.fill = false;
    }

    @Override
    public void fill(Object key, Object value) {
        try {
            MapEntry entry = (MapEntry)this.originalClass.newInstance();
            entry.setKey(key);
            entry.setValue(value);
            this.fill(entry);
        }
        catch (InstantiationException e) {
            throw new BridgeException(e, "901");
        }
        catch (IllegalAccessException e) {
            throw new BridgeException(e, "902");
        }
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.JMS.Property.JMSDoubleProperty";
    }

    @Override
    protected Object createObject() {
        MapEntry result = new MapEntry();
        result.setKey(this.getKey());
        result.setValue(this.getValue());
        return result;
    }

    private String getKey() {
        StringItem stringItem = this.getRecordItem().getStringItem(0);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setKey(String value) {
        this.setValue(0, value);
    }

    private Double getValue() {
        FloatItem floatItem = this.getRecordItem().getFloatItem(1);
        return floatItem == null ? null : floatItem.getValueAsDouble();
    }

    private void setValue(Double value) {
        this.setValue(1, value);
    }
}

