/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.impl.BaseSynchronAction;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.JMSBytesMessageImpl;
import ch.e2e.bridge.server.jms.impl.JMSTextMessageImpl;
import ch.e2e.bridge.server.jms.impl.MessageSender;
import ch.e2e.bridge.server.jms.parameter.JMSMessage;
import ch.e2e.bridge.server.jms.parameter.JMSMessageType;
import ch.e2e.bridge.server.jms.parameter.JMSSendParameter;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.parameter.JMSWrapperException;
import ch.e2e.bridge.server.jms.wrapper.JMSBytesMessageWrapper;
import ch.e2e.bridge.server.jms.wrapper.JMSSendParameterWrapper;
import ch.e2e.bridge.server.jms.wrapper.JMSTextMessageWrapper;
import ch.e2e.bridge.server.session.Session;
import java.util.Map;
import javax.jms.JMSException;

public class SendMessageAction
extends BaseSynchronAction {
    private JMSSendParameter sendParameter;

    public SendMessageAction(JMSMessageType messageType, JMSSessionParameter sessionParameter, JMSSendParameter sendParameter) {
        super(messageType, sessionParameter);
        this.sendParameter = sendParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, JMSSessionParameter sessionParameter) throws Exception {
        JMSSendParameter localSendParameter;
        sessionParameter.getSession().logEnter(3L, true, "JAVA", "SendMessageAction.execute", sessionParameter.getConnectionInfo().getURL());
        JMSMessage message = this.createMessage(inputItem, sessionParameter.getSession());
        if (message.getMessage() == null) {
            throw new BridgeException("No message specified!");
        }
        if (this.sendParameter == null) {
            localSendParameter = (JMSSendParameter)sessionParameter.getSession().createObject((RecordItem)inputItem.getItem(1L), JMSSendParameterWrapper.class);
        } else {
            localSendParameter = this.sendParameter;
            localSendParameter.merge((RecordItem)inputItem.getItem(1L));
        }
        ConnectionAdapter connection = this.borrowConnection(sessionParameter);
        MessageSender sender = null;
        try {
            sender = connection.getSender(sessionParameter.getSession().getSessionId());
        }
        finally {
            this.returnConnection(sessionParameter, connection);
        }
        if (sender != null) {
            sessionParameter.getSession().dumpIOEntry(sessionParameter.getConnectionInfo().getURL(), localSendParameter.getDestinationName(), message.getMessage().getBytes());
            try {
                sender.send(message, localSendParameter);
            }
            catch (JMSException e) {
                connection.removeJMSSession(sessionParameter.getSession().getSessionId());
                throw e;
            }
            finally {
                sessionParameter.getSession().dumpIOExit(new byte[0]);
            }
            JMSLogger.getInstance().debug("3", "JMS message sent: " + message.getMessage());
        }
        sessionParameter.getSession().logExit(3L, true, "JAVA", "SendMessageAction.execute", sessionParameter.getConnectionInfo().getURL(), message.getJmsMessageID());
        return true;
    }

    private JMSMessage createMessage(RecordItem inputItem, Session session) throws JMSWrapperException {
        JMSMessage message;
        if (this.getMessageType() == 3) {
            message = new JMSTextMessageWrapper((RecordItem)inputItem.getItem(3L), session);
        } else if (this.getMessageType() == 1) {
            message = new JMSTextMessageImpl();
            StringItem stringItem = inputItem.getStringItem(3);
            if (stringItem != null) {
                message.setMessage(stringItem.getValueAsString());
            }
        } else if (this.getMessageType() == 4) {
            message = new JMSBytesMessageWrapper((RecordItem)inputItem.getItem(3L), session);
        } else if (this.getMessageType() == 2) {
            JMSBytesMessageImpl byteMessage = new JMSBytesMessageImpl();
            BlobItem blobItem = inputItem.getBlobItem(3);
            if (blobItem != null) {
                byteMessage.setByteMessage(blobItem.byteValues());
            }
            message = byteMessage;
        } else {
            throw new JMSWrapperException("unknown type");
        }
        this.addCustomHeader(message, session.getSessionId());
        message.setHeaderIfNotNull("xTransactionId", session.getTransactionId());
        message.setHeaderIfNotNull("xSenderHost", session.getHostName());
        message.setHeaderIfNotNull("xSenderService", session.getInstanceName());
        return message;
    }

    private void addCustomHeader(JMSMessage message, String sessionId) {
        Map properties = message.getStringProperties();
        if (properties.get("E2ESessionID") != null) {
            properties.put("E2ESessionID", sessionId);
        }
    }
}

