/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import ch.e2e.bridge.server.jms.parameter.JMSMessage;
import ch.e2e.bridge.server.jms.parameter.JMSSendParameter;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;

public class MessageSender {
    private Map<String, MessageProducer> producers = new HashMap<String, MessageProducer>();
    private final Session session;
    private final ConnectionAdapter connection;

    public MessageSender(Session session, ConnectionAdapter connection) {
        this.session = session;
        this.connection = connection;
    }

    public void send(JMSMessage message, JMSSendParameter producerParameter) throws NamingException, JMSException {
        JMSLogger.getInstance().debug("3", String.format("Sending message with session %s.", this.session));
        MessageProducer producer = this.getMessageProducer(message, producerParameter);
        Message msg = message.createMessage(this.session, this.connection.getInitialContext());
        producer.send(msg);
        message.assignHeaderFromMessage(msg);
        producer.close();
    }

    public void close() {
        for (String key : this.producers.keySet()) {
            MessageProducer producer = this.producers.get(key);
            try {
                producer.close();
            }
            catch (JMSException e) {
                JMSLogger.getInstance().debug("20", String.format("MessageSender.close: Could not close MessageProducer to destination '%s'", key));
            }
        }
        this.producers.clear();
    }

    private MessageProducer getMessageProducer(JMSMessage input, JMSSendParameter producerParameter) throws JMSException, NamingException {
        String destinationName = producerParameter.getDestinationName();
        MessageProducer producer = this.producers.get(destinationName);
        if (producer == null) {
            producer = this.createProducer(destinationName);
        }
        try {
            this.initializeProducer(producer, input, producerParameter);
        }
        catch (JMSException ex) {
            producer = this.createProducer(destinationName);
            this.initializeProducer(producer, input, producerParameter);
        }
        return producer;
    }

    private void initializeProducer(MessageProducer producer, JMSMessage input, JMSSendParameter producerParameter) throws JMSException {
        producer.setDeliveryMode(input.getJMSPersistentDeliveryMode() ? 2 : 1);
        if (input.getJmsPriority() != -1) {
            producer.setPriority(input.getJmsPriority());
        }
        if (producerParameter.getTimeToLive() != 0L) {
            producer.setTimeToLive(producerParameter.getTimeToLive());
        }
    }

    private MessageProducer createProducer(String destinationName) throws JMSException, NamingException {
        Destination destination = JMSAddOnHelper.getDestination(destinationName, this.session, this.connection.getInitialContext());
        MessageProducer producer = this.session.createProducer(destination);
        this.producers.put(destinationName, producer);
        return producer;
    }

    public Session getSession() {
        return this.session;
    }
}

